/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.runner;

import com.avaje.ebean.SqlRow;
import com.avaje.ebean.SqlUpdate;
import java.sql.Timestamp;

class MigrationMetaRow {
    private int id;
    private String status;
    private String runVersion;
    private String depVersion;
    private String comment;
    private int checksum;
    private Timestamp runOn;
    private String runBy;

    MigrationMetaRow(int id, String runVersion, String priorVersion, String comment, int checksum, String runBy) {
        this.id = id;
        this.runVersion = runVersion;
        this.depVersion = priorVersion;
        this.checksum = checksum;
        this.comment = comment;
        this.runBy = runBy;
        this.runOn = new Timestamp(System.currentTimeMillis());
    }

    MigrationMetaRow(SqlRow row) {
        this.id = row.getInteger("id");
        this.status = row.getString("status");
        this.runVersion = row.getString("row_version");
        this.depVersion = row.getString("dep_version");
        this.comment = row.getString("comment");
        this.checksum = row.getInteger("checksum");
        this.runOn = row.getTimestamp("run_on");
        this.runBy = row.getString("run_by");
    }

    int getId() {
        return this.id;
    }

    String getRunVersion() {
        return this.runVersion;
    }

    int getChecksum() {
        return this.checksum;
    }

    void bindInsert(SqlUpdate insert) {
        insert.setParameter(1, (Object)this.id);
        insert.setParameter(2, (Object)"success");
        insert.setParameter(3, (Object)this.runVersion);
        insert.setParameter(4, (Object)this.depVersion);
        insert.setParameter(5, (Object)this.comment);
        insert.setParameter(6, (Object)this.checksum);
        insert.setParameter(7, (Object)this.runOn);
        insert.setParameter(8, (Object)this.runBy);
        insert.setParameter(9, (Object)"ip");
    }

    static String insertSql(String table) {
        return "insert into " + table + " (id, status, run_version, dep_version, comment, checksum, run_on, run_by, run_ip)" + " values (?,?,?,?,?,?,?,?,?)";
    }
}

