/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.runner;

import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.model.MigrationVersion;
import com.avaje.ebean.dbmigration.runner.LocalMigrationResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.avaje.classpath.scanner.Resource;
import org.avaje.classpath.scanner.ResourceFilter;
import org.avaje.classpath.scanner.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMigrationResources {
    private static final Logger logger = LoggerFactory.getLogger(LocalMigrationResources.class);
    private final ServerConfig serverConfig;
    private final DbMigrationConfig migrationConfig;
    private final List<LocalMigrationResource> versions = new ArrayList<LocalMigrationResource>();

    public LocalMigrationResources(ServerConfig serverConfig, DbMigrationConfig migrationConfig) {
        this.serverConfig = serverConfig;
        this.migrationConfig = migrationConfig;
    }

    public boolean readResources() {
        String migrationPath = this.migrationConfig.getMigrationPath();
        ClassLoader classLoader = this.serverConfig.getClassLoadConfig().getClassLoader();
        Scanner scanner = new Scanner(classLoader);
        List resourceList = scanner.scanForResources(migrationPath, (ResourceFilter)new Match(this.migrationConfig));
        logger.debug("resources: {}", (Object)resourceList);
        for (Resource resource : resourceList) {
            String filename = resource.getFilename();
            if (!filename.endsWith(this.migrationConfig.getApplySuffix())) continue;
            int pos = filename.lastIndexOf(this.migrationConfig.getApplySuffix());
            String mainName = filename.substring(0, pos);
            MigrationVersion migrationVersion = MigrationVersion.parse(mainName);
            LocalMigrationResource res = new LocalMigrationResource(migrationVersion, resource.getLocation(), resource);
            this.versions.add(res);
        }
        Collections.sort(this.versions);
        return !this.versions.isEmpty();
    }

    public List<LocalMigrationResource> getVersions() {
        return this.versions;
    }

    private static class Match
    implements ResourceFilter {
        private final DbMigrationConfig migrationConfig;

        Match(DbMigrationConfig migrationConfig) {
            this.migrationConfig = migrationConfig;
        }

        public boolean isMatch(String name) {
            return name.endsWith(this.migrationConfig.getApplySuffix());
        }
    }
}

