/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model.build;

import com.avaje.ebean.dbmigration.ddlgeneration.platform.util.IndexSet;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MCompoundForeignKey;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.build.ModelBuildContext;
import com.avaje.ebean.dbmigration.model.build.ModelBuildIntersectionTable;
import com.avaje.ebean.dbmigration.model.visitor.BaseTablePropertyVisitor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.CompoundUniqueConstraint;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.deploy.id.ImportedId;
import java.util.ArrayList;
import java.util.List;

public class ModelBuildPropertyVisitor
extends BaseTablePropertyVisitor {
    protected final ModelBuildContext ctx;
    private final MTable table;
    private final BeanDescriptor<?> beanDescriptor;
    private final IndexSet indexSet = new IndexSet();
    private MColumn lastColumn;
    private int countForeignKey;
    private int countIndex;
    private int countUnique;
    private int countCheck;

    public ModelBuildPropertyVisitor(ModelBuildContext ctx, MTable table, BeanDescriptor<?> beanDescriptor) {
        this.ctx = ctx;
        this.table = table;
        this.beanDescriptor = beanDescriptor;
        this.addCompoundUniqueConstraint(beanDescriptor.getCompoundUniqueConstraints());
    }

    private void addCompoundUniqueConstraint(CompoundUniqueConstraint[] constraints) {
        if (constraints != null) {
            for (int i = 0; i < constraints.length; ++i) {
                CompoundUniqueConstraint constraint = constraints[i];
                String[] columns = constraint.getColumns();
                this.indexSet.add(columns);
                if (constraint.isUnique()) {
                    String uqName = constraint.getName();
                    if (uqName == null || uqName.trim().isEmpty()) {
                        uqName = this.determineUniqueConstraintName(columns);
                    }
                    this.table.addCompoundUniqueConstraint(columns, false, uqName);
                    continue;
                }
                String idxName = constraint.getName();
                if (idxName == null || idxName.trim().isEmpty()) {
                    idxName = this.determineIndexName(columns);
                }
                this.ctx.addIndex(idxName, this.table.getName(), columns);
            }
        }
    }

    @Override
    public void visitEnd() {
        this.table.setPkName(this.determinePrimaryKeyName());
        for (MColumn column : this.table.allColumns()) {
            if (!this.hasValue(column.getForeignKeyIndex()) || !this.indexSet.contains(column.getName())) continue;
            column.setForeignKeyIndex(null);
        }
        for (MCompoundForeignKey compoundKey : this.table.getCompoundKeys()) {
            if (!this.indexSet.contains(compoundKey.getColumns())) continue;
            compoundKey.setIndexName(null);
        }
        this.addDraftTable();
    }

    private void addDraftTable() {
        if (this.beanDescriptor.isDraftable() || this.beanDescriptor.isDraftableElement()) {
            this.ctx.createDraft(this.table, !this.beanDescriptor.isDraftableElement());
        }
    }

    @Override
    public void visitMany(BeanPropertyAssocMany<?> p) {
        if (p.isManyToMany() && p.getMappedBy() == null) {
            new ModelBuildIntersectionTable(this.ctx, p).build();
        }
    }

    @Override
    public void visitCompoundScalar(BeanPropertyCompound compound, BeanProperty p) {
        this.visitScalar(p);
    }

    @Override
    public void visitCompound(BeanPropertyCompound p) {
    }

    @Override
    public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
        this.visitScalar(p);
        if (embedded.isId()) {
            this.lastColumn.setPrimaryKey(true);
        }
    }

    @Override
    public void visitOneImported(BeanPropertyAssocOne<?> p) {
        TableJoinColumn[] columns = p.getTableJoin().columns();
        if (columns.length == 0) {
            String msg = "No join columns for " + p.getFullBeanName();
            throw new RuntimeException(msg);
        }
        ImportedId importedId = p.getImportedId();
        ArrayList<MColumn> modelColumns = new ArrayList<MColumn>(columns.length);
        MCompoundForeignKey compoundKey = null;
        if (columns.length > 1) {
            String refTable = p.getTargetDescriptor().getBaseTable();
            String fkName = this.determineForeignKeyConstraintName(p.getName());
            String fkIndex = this.determineForeignKeyIndexName(p.getName());
            compoundKey = new MCompoundForeignKey(fkName, refTable, fkIndex);
            this.table.addForeignKey(compoundKey);
        }
        for (int i = 0; i < columns.length; ++i) {
            String dbCol = columns[i].getLocalDbColumn();
            BeanProperty importedProperty = importedId.findMatchImport(dbCol);
            if (importedProperty == null) {
                throw new RuntimeException("Imported BeanProperty not found?");
            }
            String columnDefn = this.ctx.getColumnDefn(importedProperty);
            String refColumn = importedProperty.getDbColumn();
            MColumn col = this.table.addColumn(dbCol, columnDefn, !p.isNullable());
            if (columns.length == 1) {
                String refTable = importedProperty.getBeanDescriptor().getBaseTable();
                if (refTable == null) {
                    refTable = p.getTargetDescriptor().getBaseTable();
                }
                col.setReferences(refTable + "." + refColumn);
                col.setForeignKeyName(this.determineForeignKeyConstraintName(col.getName()));
                col.setForeignKeyIndex(this.determineForeignKeyIndexName(col.getName()));
            } else {
                compoundKey.addColumnPair(dbCol, refColumn);
            }
            modelColumns.add(col);
        }
        if (p.isOneToOne()) {
            if (modelColumns.size() == 1) {
                MColumn col = (MColumn)modelColumns.get(0);
                col.setUniqueOneToOne(this.determineUniqueConstraintName(col.getName()));
                this.indexSetAdd(col.getName());
            } else {
                String uqName = this.determineUniqueConstraintName(p.getName());
                this.table.addCompoundUniqueConstraint(modelColumns, true, uqName);
                this.indexSetAdd(modelColumns);
            }
        }
    }

    @Override
    public void visitScalar(BeanProperty p) {
        String indexName;
        String checkConstraint;
        if (p.isSecondaryTable()) {
            this.lastColumn = null;
            return;
        }
        MColumn col = new MColumn(p.getDbColumn(), this.ctx.getColumnDefn(p));
        col.setDefaultValue(p.getDbColumnDefault());
        col.setComment(p.getDbComment());
        col.setDraftOnly(p.isDraftOnly());
        if (p.isId()) {
            col.setPrimaryKey(true);
            if (p.getBeanDescriptor().isUseIdGenerator()) {
                col.setIdentity(true);
            }
        } else if (!p.isNullable() || p.isDDLNotNull()) {
            col.setNotnull(true);
        }
        if (p.isUnique() && !p.isId()) {
            col.setUnique(this.determineUniqueConstraintName(col.getName()));
            this.indexSetAdd(col.getName());
        }
        if ((checkConstraint = p.getDbConstraintExpression()) != null) {
            col.setCheckConstraint(checkConstraint);
            col.setCheckConstraintName(this.determineCheckConstraintName(col.getName()));
        }
        if ((indexName = p.getIndexName()) != null) {
            if (indexName.trim().isEmpty()) {
                indexName = this.determineIndexName(col.getName());
            }
            this.ctx.addIndex(indexName, this.table.getName(), p.getDbColumn());
        }
        this.lastColumn = col;
        this.table.addColumn(col);
    }

    private void indexSetAdd(String column) {
        this.indexSet.add(column);
    }

    private void indexSetAdd(List<MColumn> modelColumns) {
        String[] cols = new String[modelColumns.size()];
        for (int i = 0; i < modelColumns.size(); ++i) {
            cols[i] = modelColumns.get(i).getName();
        }
        this.indexSet.add(cols);
    }

    protected String determinePrimaryKeyName() {
        return this.ctx.primaryKeyName(this.table.getName());
    }

    protected String determineForeignKeyConstraintName(String columnName) {
        return this.ctx.foreignKeyConstraintName(this.table.getName(), columnName, ++this.countForeignKey);
    }

    protected String determineForeignKeyIndexName(String column) {
        String[] cols = new String[]{column};
        return this.determineForeignKeyIndexName(cols);
    }

    protected String determineForeignKeyIndexName(String[] columns) {
        return this.ctx.foreignKeyIndexName(this.table.getName(), columns, ++this.countIndex);
    }

    protected String determineIndexName(String column) {
        return this.ctx.indexName(this.table.getName(), column, ++this.countIndex);
    }

    protected String determineIndexName(String[] columns) {
        return this.ctx.indexName(this.table.getName(), columns, ++this.countIndex);
    }

    protected String determineUniqueConstraintName(String columnName) {
        return this.ctx.uniqueConstraintName(this.table.getName(), columnName, ++this.countUnique);
    }

    protected String determineUniqueConstraintName(String[] columnNames) {
        return this.ctx.uniqueConstraintName(this.table.getName(), columnNames, ++this.countUnique);
    }

    protected String determineCheckConstraintName(String columnName) {
        return this.ctx.checkConstraintName(this.table.getName(), columnName, ++this.countCheck);
    }

    private boolean hasValue(String val) {
        return val != null && !val.isEmpty();
    }
}

