/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import java.io.IOException;

public class MsSqlServerDdl
extends PlatformDdl {
    public MsSqlServerDdl(DatabasePlatform platform) {
        super(platform);
        this.identitySuffix = " identity(1,1)";
        this.foreignKeyRestrict = "";
        this.inlineUniqueOneToOne = false;
        this.columnSetDefault = "add default";
        this.dropConstraintIfExists = "drop constraint";
    }

    @Override
    public String dropTable(String tableName) {
        return "IF OBJECT_ID('" + tableName + "', 'U') IS NOT NULL drop table " + tableName;
    }

    @Override
    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "IF OBJECT_ID('" + fkName + "', 'F') IS NOT NULL " + super.alterTableDropForeignKey(tableName, fkName);
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns) {
        int i;
        String start = "create unique nonclustered index " + uqName + " on " + tableName + "(";
        StringBuilder sb = new StringBuilder(start);
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        sb.append(") where");
        for (i = 0; i < columns.length; ++i) {
            sb.append(" ").append(columns[i]).append(" is not null");
        }
        return sb.toString();
    }

    @Override
    public String alterColumnDefaultValue(String tableName, String columnName, String defaultValue) {
        if (this.isDropDefault(defaultValue)) {
            return "-- alter table " + tableName + " drop constraint <unknown>  -- find the appropriate constraint for default value on column " + columnName;
        }
        return "alter table " + tableName + " add default " + defaultValue + " for " + columnName;
    }

    @Override
    public String alterColumnBaseAttributes(AlterColumn alter) {
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        String type = alter.getType() != null ? alter.getType() : alter.getCurrentType();
        boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
        String notnullClause = notnull ? " not null" : "";
        return "alter table " + tableName + " alter column " + columnName + " " + type + notnullClause;
    }

    @Override
    public String alterColumnType(String tableName, String columnName, String type) {
        return null;
    }

    @Override
    public String alterColumnNotnull(String tableName, String columnName, boolean notnull) {
        return null;
    }

    @Override
    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) throws IOException {
    }

    @Override
    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) throws IOException {
    }
}

