/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.dbplatform.H2HistoryTrigger;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;

public class H2HistoryDdl
extends DbTriggerBasedHistoryDdl {
    private static final String TRIGGER_CLASS = H2HistoryTrigger.class.getName();

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        String baseTableName = table.getName();
        DdlBuffer apply = writer.applyHistory();
        this.addCreateTrigger(apply, this.updateTriggerName(baseTableName), baseTableName);
    }

    @Override
    protected void updateHistoryTriggers(DbTriggerUpdate update) throws IOException {
        DdlBuffer buffer = update.historyBuffer();
        this.dropTriggers(buffer, update.getBaseTable());
        this.addCreateTrigger(buffer, this.updateTriggerName(update.getBaseTable()), update.getBaseTable());
    }

    private void addCreateTrigger(DdlBuffer apply, String triggerName, String baseTable) throws IOException {
        apply.append("create trigger ").append(triggerName).append(" before update,delete on ").append(baseTable).append(" for each row call \"" + TRIGGER_CLASS + "\";").newLine();
    }
}

