/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.TableDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.BaseTableDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import com.avaje.ebean.dbmigration.migration.AddColumn;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.ChangeSet;
import com.avaje.ebean.dbmigration.migration.CreateIndex;
import com.avaje.ebean.dbmigration.migration.CreateTable;
import com.avaje.ebean.dbmigration.migration.DropColumn;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropIndex;
import com.avaje.ebean.dbmigration.migration.DropTable;
import java.io.IOException;
import java.util.List;

public class BaseDdlHandler
implements DdlHandler {
    protected final TableDdl tableDdl;

    public BaseDdlHandler(ServerConfig serverConfig, PlatformDdl platformDdl) {
        this.tableDdl = new BaseTableDdl(serverConfig, platformDdl);
    }

    @Override
    public void generate(DdlWrite writer, ChangeSet changeSet) throws IOException {
        List<Object> changeSetChildren = changeSet.getChangeSetChildren();
        for (Object change : changeSetChildren) {
            if (change instanceof CreateTable) {
                this.generate(writer, (CreateTable)change);
                continue;
            }
            if (change instanceof DropTable) {
                this.generate(writer, (DropTable)change);
                continue;
            }
            if (change instanceof CreateIndex) {
                this.generate(writer, (CreateIndex)change);
                continue;
            }
            if (change instanceof DropIndex) {
                this.generate(writer, (DropIndex)change);
                continue;
            }
            if (change instanceof AddColumn) {
                this.generate(writer, (AddColumn)change);
                continue;
            }
            if (change instanceof DropColumn) {
                this.generate(writer, (DropColumn)change);
                continue;
            }
            if (change instanceof AlterColumn) {
                this.generate(writer, (AlterColumn)change);
                continue;
            }
            if (change instanceof AddHistoryTable) {
                this.generate(writer, (AddHistoryTable)change);
                continue;
            }
            if (!(change instanceof DropHistoryTable)) continue;
            this.generate(writer, (DropHistoryTable)change);
        }
    }

    @Override
    public void generateExtra(DdlWrite write) throws IOException {
        this.tableDdl.generateExtra(write);
    }

    @Override
    public void generate(DdlWrite writer, CreateTable createTable) throws IOException {
        this.tableDdl.generate(writer, createTable);
    }

    @Override
    public void generate(DdlWrite writer, DropTable dropTable) throws IOException {
        this.tableDdl.generate(writer, dropTable);
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) throws IOException {
        this.tableDdl.generate(writer, addColumn);
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) throws IOException {
        this.tableDdl.generate(writer, dropColumn);
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        this.tableDdl.generate(writer, alterColumn);
    }

    @Override
    public void generate(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        this.tableDdl.generate(writer, addHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        this.tableDdl.generate(writer, dropHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, CreateIndex createIndex) throws IOException {
        this.tableDdl.generate(writer, createIndex);
    }

    @Override
    public void generate(DdlWrite writer, DropIndex dropIndex) throws IOException {
        this.tableDdl.generate(writer, dropIndex);
    }
}

