/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.dbmigration.DdlParser;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlRunner {
    protected static final Logger logger = LoggerFactory.getLogger(DdlRunner.class);
    protected DdlParser ddlParser = new DdlParser();
    protected final String scriptName;
    protected final boolean expectErrors;

    public DdlRunner(boolean expectErrors, String scriptName) {
        this.expectErrors = expectErrors;
        this.scriptName = scriptName;
    }

    public int runAll(String content, Connection connection) {
        List<String> statements = this.ddlParser.parse(new StringReader(content));
        return this.runStatements(statements, connection);
    }

    public int runStatements(List<String> statements, Connection connection) {
        try {
            int statementCount = this.runStatements(this.expectErrors, statements, connection);
            connection.commit();
            return statementCount;
        }
        catch (Exception e) {
            this.rollback(connection);
            throw new PersistenceException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void rollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException e) {
            logger.error("Error trying to rollback connection", (Throwable)e);
        }
    }

    private int runStatements(boolean expectErrors, List<String> statements, Connection c) {
        ArrayList<String> noDuplicates = new ArrayList<String>();
        for (String statement : statements) {
            if (noDuplicates.contains(statement)) continue;
            noDuplicates.add(statement);
        }
        logger.info("Executing {} - {} statements", (Object)this.scriptName, (Object)noDuplicates.size());
        for (int i = 0; i < noDuplicates.size(); ++i) {
            String xOfy = i + 1 + " of " + noDuplicates.size();
            this.runStatement(expectErrors, xOfy, (String)noDuplicates.get(i), c);
        }
        return noDuplicates.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStatement(boolean expectErrors, String oneOf, String stmt, Connection c) {
        block17: {
            Statement pstmt = null;
            try {
                stmt = stmt.trim();
                if (stmt.endsWith(";")) {
                    stmt = stmt.substring(0, stmt.length() - 1);
                } else if (stmt.endsWith("/")) {
                    stmt = stmt.substring(0, stmt.length() - 1);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("executing " + oneOf + " " + this.getSummary(stmt));
                }
                pstmt = c.prepareStatement(stmt);
                pstmt.execute();
            }
            catch (Exception e) {
                if (expectErrors) {
                    logger.debug(" ... ignoring error executing " + this.getSummary(stmt) + "  error: " + e.getMessage());
                    break block17;
                }
                String msg = "Error executing stmt[" + stmt + "] error[" + e.getMessage() + "]";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        logger.error("Error closing pstmt", (Throwable)e);
                    }
                }
            }
        }
    }

    private String getSummary(String s) {
        if (s.length() > 80) {
            return s.substring(0, 80).trim() + "...";
        }
        return s;
    }
}

