/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.PropertyExpression;
import com.avaje.ebean.config.PropertyMapLoader;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class PropertyMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedHashMap<String, String> map = new LinkedHashMap();

    public static Properties testProperties() {
        PropertyMap propertyMap = PropertyMapLoader.loadTestProperties();
        return propertyMap == null ? new Properties() : propertyMap.asProperties();
    }

    public static Properties defaultProperties() {
        PropertyMap propertyMap = PropertyMapLoader.loadGlobalProperties();
        return propertyMap == null ? new Properties() : propertyMap.asProperties();
    }

    public static boolean loadTestProperties() {
        String disable = System.getProperty("disableTestProperties");
        return disable == null || !disable.equalsIgnoreCase("true");
    }

    public String toString() {
        return this.map.toString();
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : this.entrySet()) {
            properties.put(e.getKey(), e.getValue());
        }
        return properties;
    }

    public void evaluateProperties() {
        for (Map.Entry<String, String> e : this.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            String eval = this.eval(val);
            if (eval == null || eval.equals(val)) continue;
            this.put(key, eval);
        }
    }

    public synchronized String eval(String val) {
        return PropertyExpression.eval(val, this);
    }

    public synchronized boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public synchronized int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public synchronized long getLong(String key, long defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public synchronized String get(String key, String defaultValue) {
        String value = this.map.get(key.toLowerCase());
        return value == null ? defaultValue : value;
    }

    public synchronized String get(String key) {
        return this.map.get(key.toLowerCase());
    }

    public synchronized void putEvalAll(Map<String, String> keyValueMap) {
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            this.putEval(entry.getKey(), entry.getValue());
        }
    }

    public synchronized String putEval(String key, String value) {
        value = PropertyExpression.eval(value, this);
        return this.map.put(key.toLowerCase(), value);
    }

    public synchronized String put(String key, String value) {
        return this.map.put(key.toLowerCase(), value);
    }

    public synchronized String remove(String key) {
        return (String)this.map.remove(key.toLowerCase());
    }

    public synchronized Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }
}

