/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.PropertiesWrapper;
import com.avaje.ebean.config.TableName;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import javax.persistence.Inheritance;
import javax.persistence.Table;

public abstract class AbstractNamingConvention
implements NamingConvention {
    public static final String DEFAULT_SEQ_FORMAT = "{table}_seq";
    public static final String TABLE_PKCOLUMN_SEQ_FORMAT = "{table}_{column}_seq";
    private String catalog;
    private String schema;
    private String sequenceFormat;
    protected DatabasePlatform databasePlatform;
    protected int rhsPrefixLength = 3;
    protected boolean useForeignKeyPrefix;

    public AbstractNamingConvention(String sequenceFormat, boolean useForeignKeyPrefix) {
        this.sequenceFormat = sequenceFormat;
        this.useForeignKeyPrefix = useForeignKeyPrefix;
    }

    public AbstractNamingConvention(String sequenceFormat) {
        this.sequenceFormat = sequenceFormat;
        this.useForeignKeyPrefix = true;
    }

    public AbstractNamingConvention() {
        this(DEFAULT_SEQ_FORMAT);
    }

    @Override
    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    @Override
    public String getSequenceName(String tableName, String pkColumn) {
        String s = this.sequenceFormat.replace("{table}", tableName);
        if (pkColumn == null) {
            pkColumn = "";
        }
        return s.replace("{column}", pkColumn);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSequenceFormat() {
        return this.sequenceFormat;
    }

    public void setSequenceFormat(String sequenceFormat) {
        this.sequenceFormat = sequenceFormat;
    }

    @Override
    public boolean isUseForeignKeyPrefix() {
        return this.useForeignKeyPrefix;
    }

    public void setUseForeignKeyPrefix(boolean useForeignKeyPrefix) {
        this.useForeignKeyPrefix = useForeignKeyPrefix;
    }

    protected abstract TableName getTableNameByConvention(Class<?> var1);

    @Override
    public TableName getTableName(Class<?> beanClass) {
        String schema;
        String catalog;
        TableName tableName = this.getTableNameFromAnnotation(beanClass);
        if (tableName == null) {
            Class<?> supCls = beanClass.getSuperclass();
            Inheritance inheritance = supCls.getAnnotation(Inheritance.class);
            if (inheritance != null) {
                return this.getTableName(supCls);
            }
            tableName = this.getTableNameByConvention(beanClass);
        }
        if (this.isEmpty(catalog = tableName.getCatalog())) {
            catalog = this.getCatalog();
        }
        if (this.isEmpty(schema = tableName.getSchema())) {
            schema = this.getSchema();
        }
        return new TableName(catalog, schema, tableName.getName());
    }

    @Override
    public TableName getM2MJoinTableName(TableName lhsTable, TableName rhsTable) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(lhsTable.getName());
        buffer.append("_");
        String rhsTableName = rhsTable.getName();
        if (rhsTableName.indexOf(95) < this.rhsPrefixLength) {
            rhsTableName = rhsTableName.substring(rhsTableName.indexOf(95) + 1);
        }
        buffer.append(rhsTableName);
        int maxTableNameLength = this.databasePlatform.getMaxTableNameLength();
        if (buffer.length() > maxTableNameLength) {
            buffer.setLength(maxTableNameLength);
        }
        return new TableName(lhsTable.getCatalog(), lhsTable.getSchema(), buffer.toString());
    }

    protected TableName getTableNameFromAnnotation(Class<?> beanClass) {
        Table t = this.findTableAnnotation(beanClass);
        if (t != null && !this.isEmpty(t.name())) {
            return new TableName(this.quoteIdentifiers(t.catalog()), this.quoteIdentifiers(t.schema()), this.quoteIdentifiers(t.name()));
        }
        return null;
    }

    protected Table findTableAnnotation(Class<?> cls) {
        if (cls.equals(Object.class)) {
            return null;
        }
        Table table = cls.getAnnotation(Table.class);
        if (table != null) {
            return table;
        }
        return this.findTableAnnotation(cls.getSuperclass());
    }

    protected String quoteIdentifiers(String s) {
        return this.databasePlatform.convertQuotedIdentifiers(s);
    }

    protected boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public void loadFromProperties(PropertiesWrapper properties) {
        this.useForeignKeyPrefix = properties.getBoolean("namingConvention.useForeignKeyPrefix", this.useForeignKeyPrefix);
        this.sequenceFormat = properties.get("namingConvention.sequenceFormat", this.sequenceFormat);
        this.schema = properties.get("namingConvention.schema", this.schema);
    }
}

