/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.cache;

import com.avaje.ebean.annotation.CacheTuning;

public class ServerCacheOptions {
    private int maxSize;
    private int maxIdleSecs;
    private int maxSecsToLive;
    private int trimFrequency;

    public ServerCacheOptions() {
    }

    public ServerCacheOptions(CacheTuning cacheTuning) {
        this.maxSize = cacheTuning.maxSize();
        this.maxIdleSecs = cacheTuning.maxIdleSecs();
        this.maxSecsToLive = cacheTuning.maxSecsToLive();
        this.trimFrequency = cacheTuning.trimFrequency();
    }

    public ServerCacheOptions(ServerCacheOptions defaults) {
        this.maxSize = defaults.getMaxSize();
        this.maxIdleSecs = defaults.getMaxIdleSecs();
        this.maxSecsToLive = defaults.getMaxIdleSecs();
        this.trimFrequency = defaults.getTrimFrequency();
    }

    public void applyDefaults(ServerCacheOptions defaults) {
        if (this.maxSize == 0) {
            this.maxSize = defaults.getMaxSize();
        }
        if (this.maxIdleSecs == 0) {
            this.maxIdleSecs = defaults.getMaxIdleSecs();
        }
        if (this.maxSecsToLive == 0) {
            this.maxSecsToLive = defaults.getMaxSecsToLive();
        }
        if (this.trimFrequency == 0) {
            this.trimFrequency = defaults.getTrimFrequency();
        }
    }

    public ServerCacheOptions copy() {
        ServerCacheOptions copy = new ServerCacheOptions();
        copy.maxSize = this.maxSize;
        copy.maxIdleSecs = this.maxIdleSecs;
        copy.maxSecsToLive = this.maxSecsToLive;
        copy.trimFrequency = this.trimFrequency;
        return copy;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxIdleSecs() {
        return this.maxIdleSecs;
    }

    public void setMaxIdleSecs(int maxIdleSecs) {
        this.maxIdleSecs = maxIdleSecs;
    }

    public int getMaxSecsToLive() {
        return this.maxSecsToLive;
    }

    public void setMaxSecsToLive(int maxSecsToLive) {
        this.maxSecsToLive = maxSecsToLive;
    }

    public int getTrimFrequency() {
        return this.trimFrequency;
    }

    public void setTrimFrequency(int trimFrequency) {
        this.trimFrequency = trimFrequency;
    }
}

