/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.BeanState;
import com.avaje.ebean.CallableSql;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.Filter;
import com.avaje.ebean.PrimaryServer;
import com.avaje.ebean.Query;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.TransactionCallback;
import com.avaje.ebean.TxCallable;
import com.avaje.ebean.TxIsolation;
import com.avaje.ebean.TxRunnable;
import com.avaje.ebean.TxScope;
import com.avaje.ebean.Update;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.text.csv.CsvReader;
import com.avaje.ebean.text.json.JsonContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ebean {
    private static final Logger logger = LoggerFactory.getLogger(Ebean.class);
    private static final ServerManager serverMgr = new ServerManager();

    private Ebean() {
    }

    public static EbeanServer getServer(String name) {
        return Ebean.serverMgr.get(name);
    }

    public static EbeanServer getDefaultServer() {
        return Ebean.serverMgr.getDefaultServer();
    }

    public static ExpressionFactory getExpressionFactory() {
        return Ebean.serverMgr.getDefaultServer().getExpressionFactory();
    }

    public static void register(EbeanServer server, boolean defaultServer) {
        Ebean.serverMgr.register(server, defaultServer);
    }

    protected static EbeanServer mock(String name, EbeanServer server, boolean defaultServer) {
        EbeanServer originalPrimaryServer = serverMgr.defaultServer;
        Ebean.serverMgr.registerWithName(name, server, defaultServer);
        return originalPrimaryServer;
    }

    public static Object nextId(Class<?> beanType) {
        return Ebean.serverMgr.getDefaultServer().nextId(beanType);
    }

    public static Transaction beginTransaction() {
        return Ebean.serverMgr.getDefaultServer().beginTransaction();
    }

    public static Transaction beginTransaction(TxIsolation isolation) {
        return Ebean.serverMgr.getDefaultServer().beginTransaction(isolation);
    }

    public static Transaction beginTransaction(TxScope scope) {
        return Ebean.serverMgr.getDefaultServer().beginTransaction(scope);
    }

    public static Transaction currentTransaction() {
        return Ebean.serverMgr.getDefaultServer().currentTransaction();
    }

    public static void register(TransactionCallback transactionCallback) throws PersistenceException {
        Ebean.serverMgr.getDefaultServer().register(transactionCallback);
    }

    public static void commitTransaction() {
        Ebean.serverMgr.getDefaultServer().commitTransaction();
    }

    public static void rollbackTransaction() {
        Ebean.serverMgr.getDefaultServer().rollbackTransaction();
    }

    public static void endTransaction() {
        Ebean.serverMgr.getDefaultServer().endTransaction();
    }

    public static Map<String, ValuePair> diff(Object a, Object b) {
        return Ebean.serverMgr.getDefaultServer().diff(a, b);
    }

    public static void save(Object bean) throws OptimisticLockException {
        Ebean.serverMgr.getDefaultServer().save(bean);
    }

    public static void insert(Object bean) {
        Ebean.serverMgr.getDefaultServer().insert(bean);
    }

    public static void insertAll(Collection<?> beans) {
        Ebean.serverMgr.getDefaultServer().insertAll(beans);
    }

    public static void markAsDirty(Object bean) throws OptimisticLockException {
        Ebean.serverMgr.getDefaultServer().markAsDirty(bean);
    }

    public static void update(Object bean) throws OptimisticLockException {
        Ebean.serverMgr.getDefaultServer().update(bean);
    }

    public static void updateAll(Collection<?> beans) throws OptimisticLockException {
        Ebean.serverMgr.getDefaultServer().updateAll(beans);
    }

    public static int saveAll(Collection<?> beans) throws OptimisticLockException {
        return Ebean.serverMgr.getDefaultServer().saveAll(beans);
    }

    public static int deleteManyToManyAssociations(Object ownerBean, String propertyName) {
        return Ebean.serverMgr.getDefaultServer().deleteManyToManyAssociations(ownerBean, propertyName);
    }

    public static void saveManyToManyAssociations(Object ownerBean, String propertyName) {
        Ebean.serverMgr.getDefaultServer().saveManyToManyAssociations(ownerBean, propertyName);
    }

    public static void saveAssociation(Object ownerBean, String propertyName) {
        Ebean.serverMgr.getDefaultServer().saveAssociation(ownerBean, propertyName);
    }

    public static boolean delete(Object bean) throws OptimisticLockException {
        return Ebean.serverMgr.getDefaultServer().delete(bean);
    }

    public static boolean deletePermanent(Object bean) throws OptimisticLockException {
        return Ebean.serverMgr.getDefaultServer().deletePermanent(bean);
    }

    public static int delete(Class<?> beanType, Object id) {
        return Ebean.serverMgr.getDefaultServer().delete(beanType, id);
    }

    public static void deleteAll(Class<?> beanType, Collection<?> ids) {
        Ebean.serverMgr.getDefaultServer().deleteAll(beanType, ids);
    }

    public static int deleteAll(Collection<?> beans) throws OptimisticLockException {
        return Ebean.serverMgr.getDefaultServer().deleteAll(beans);
    }

    public static int deleteAllPermanent(Collection<?> beans) throws OptimisticLockException {
        return Ebean.serverMgr.getDefaultServer().deleteAllPermanent(beans);
    }

    public static void refresh(Object bean) {
        Ebean.serverMgr.getDefaultServer().refresh(bean);
    }

    public static void refreshMany(Object bean, String manyPropertyName) {
        Ebean.serverMgr.getDefaultServer().refreshMany(bean, manyPropertyName);
    }

    public static <T> T getReference(Class<T> beanType, Object id) {
        return Ebean.serverMgr.getDefaultServer().getReference(beanType, id);
    }

    public static <T> void sort(List<T> list, String sortByClause) {
        Ebean.serverMgr.getDefaultServer().sort(list, sortByClause);
    }

    @Nullable
    public static <T> T find(Class<T> beanType, Object id) {
        return Ebean.serverMgr.getDefaultServer().find(beanType, id);
    }

    public static SqlQuery createSqlQuery(String sql) {
        return Ebean.serverMgr.getDefaultServer().createSqlQuery(sql);
    }

    public static SqlQuery createNamedSqlQuery(String namedQuery) {
        return Ebean.serverMgr.getDefaultServer().createNamedSqlQuery(namedQuery);
    }

    public static SqlUpdate createSqlUpdate(String sql) {
        return Ebean.serverMgr.getDefaultServer().createSqlUpdate(sql);
    }

    public static CallableSql createCallableSql(String sql) {
        return Ebean.serverMgr.getDefaultServer().createCallableSql(sql);
    }

    public static SqlUpdate createNamedSqlUpdate(String namedQuery) {
        return Ebean.serverMgr.getDefaultServer().createNamedSqlUpdate(namedQuery);
    }

    public static <T> Query<T> createNamedQuery(Class<T> beanType, String namedQuery) {
        return Ebean.serverMgr.getDefaultServer().createNamedQuery(beanType, namedQuery);
    }

    public static <T> Query<T> createQuery(Class<T> beanType, String query) {
        return Ebean.serverMgr.getDefaultServer().createQuery(beanType, query);
    }

    public static <T> Update<T> createNamedUpdate(Class<T> beanType, String namedUpdate) {
        return Ebean.serverMgr.getDefaultServer().createNamedUpdate(beanType, namedUpdate);
    }

    public static <T> Update<T> createUpdate(Class<T> beanType, String ormUpdate) {
        return Ebean.serverMgr.getDefaultServer().createUpdate(beanType, ormUpdate);
    }

    public static <T> CsvReader<T> createCsvReader(Class<T> beanType) {
        return Ebean.serverMgr.getDefaultServer().createCsvReader(beanType);
    }

    public static <T> Query<T> createQuery(Class<T> beanType) {
        return Ebean.serverMgr.getDefaultServer().createQuery(beanType);
    }

    public static <T> Query<T> find(Class<T> beanType) {
        return Ebean.serverMgr.getDefaultServer().find(beanType);
    }

    public static <T> Filter<T> filter(Class<T> beanType) {
        return Ebean.serverMgr.getDefaultServer().filter(beanType);
    }

    public static int execute(SqlUpdate sqlUpdate) {
        return Ebean.serverMgr.getDefaultServer().execute(sqlUpdate);
    }

    public static int execute(CallableSql callableSql) {
        return Ebean.serverMgr.getDefaultServer().execute(callableSql);
    }

    public static void execute(TxScope scope, TxRunnable r) {
        Ebean.serverMgr.getDefaultServer().execute(scope, r);
    }

    public static void execute(TxRunnable r) {
        Ebean.serverMgr.getDefaultServer().execute(r);
    }

    public static <T> T execute(TxScope scope, TxCallable<T> c) {
        return Ebean.serverMgr.getDefaultServer().execute(scope, c);
    }

    public static <T> T execute(TxCallable<T> c) {
        return Ebean.serverMgr.getDefaultServer().execute(c);
    }

    public static void externalModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        Ebean.serverMgr.getDefaultServer().externalModification(tableName, inserts, updates, deletes);
    }

    public static BeanState getBeanState(Object bean) {
        return Ebean.serverMgr.getDefaultServer().getBeanState(bean);
    }

    public static ServerCacheManager getServerCacheManager() {
        return Ebean.serverMgr.getDefaultServer().getServerCacheManager();
    }

    public static BackgroundExecutor getBackgroundExecutor() {
        return Ebean.serverMgr.getDefaultServer().getBackgroundExecutor();
    }

    public static void runCacheWarming() {
        Ebean.serverMgr.getDefaultServer().runCacheWarming();
    }

    public static void runCacheWarming(Class<?> beanType) {
        Ebean.serverMgr.getDefaultServer().runCacheWarming(beanType);
    }

    public static JsonContext json() {
        return Ebean.serverMgr.getDefaultServer().json();
    }

    private static final class ServerManager {
        private final ConcurrentHashMap<String, EbeanServer> concMap = new ConcurrentHashMap();
        private final HashMap<String, EbeanServer> syncMap = new HashMap();
        private final Object monitor = new Object();
        private EbeanServer defaultServer;

        private ServerManager() {
            try {
                if (PrimaryServer.isSkip()) {
                    logger.debug("PrimaryServer.isSkip()");
                } else {
                    String defaultName = PrimaryServer.getDefaultServerName();
                    logger.debug("defaultName:" + defaultName);
                    if (defaultName != null && defaultName.trim().length() > 0) {
                        this.defaultServer = this.getWithCreate(defaultName.trim());
                    }
                }
            }
            catch (Throwable e) {
                logger.error("Error trying to create the default EbeanServer", e);
                throw new RuntimeException(e);
            }
        }

        private EbeanServer getDefaultServer() {
            if (this.defaultServer == null) {
                String msg = "The default EbeanServer has not been defined?";
                msg = msg + " This is normally set via the ebean.datasource.default property.";
                msg = msg + " Otherwise it should be registered programmatically via registerServer()";
                throw new PersistenceException(msg);
            }
            return this.defaultServer;
        }

        private EbeanServer get(String name) {
            if (name == null || name.length() == 0) {
                return this.defaultServer;
            }
            EbeanServer server = this.concMap.get(name);
            if (server != null) {
                return server;
            }
            return this.getWithCreate(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EbeanServer getWithCreate(String name) {
            Object object = this.monitor;
            synchronized (object) {
                EbeanServer server = this.syncMap.get(name);
                if (server == null) {
                    server = EbeanServerFactory.create(name);
                    this.register(server, false);
                }
                return server;
            }
        }

        private void register(EbeanServer server, boolean isDefaultServer) {
            this.registerWithName(server.getName(), server, isDefaultServer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerWithName(String name, EbeanServer server, boolean isDefaultServer) {
            Object object = this.monitor;
            synchronized (object) {
                this.concMap.put(name, server);
                this.syncMap.put(name, server);
                if (isDefaultServer) {
                    this.defaultServer = server;
                }
            }
        }
    }
}

