/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.socket;

import com.avaje.ebeaninternal.server.cluster.ClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.cluster.SocketConfig;
import com.avaje.ebeaninternal.server.cluster.message.ClusterMessage;
import com.avaje.ebeaninternal.server.cluster.message.MessageReadWrite;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClient;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterListener;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterStatus;
import com.avaje.ebeaninternal.server.cluster.socket.SocketConnection;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClusterBroadcast
implements ClusterBroadcast {
    private static final Logger clusterLogger = LoggerFactory.getLogger((String)"org.avaje.ebean.Cluster");
    private static final Logger logger = LoggerFactory.getLogger(SocketClusterBroadcast.class);
    private final SocketClient local;
    private final HashMap<String, SocketClient> clientMap;
    private final SocketClusterListener listener;
    private final SocketClient[] members;
    private final MessageReadWrite messageReadWrite;
    private final AtomicLong countOutgoing = new AtomicLong();
    private final AtomicLong countIncoming = new AtomicLong();

    public SocketClusterBroadcast(ClusterManager manager, SocketConfig config) {
        this.messageReadWrite = new MessageReadWrite(manager);
        String localHostPort = config.getLocalHostPort();
        List<String> members = config.getMembers();
        clusterLogger.info("Clustering using local[{}] members[{}]", (Object)localHostPort, members);
        this.local = new SocketClient(this.parseFullName(localHostPort));
        this.clientMap = new HashMap();
        for (String memberHostPort : members) {
            InetSocketAddress member = this.parseFullName(memberHostPort);
            SocketClient client = new SocketClient(member);
            if (this.local.getHostPort().equalsIgnoreCase(client.getHostPort())) continue;
            this.clientMap.put(client.getHostPort(), client);
        }
        this.members = this.clientMap.values().toArray(new SocketClient[this.clientMap.size()]);
        this.listener = new SocketClusterListener(this, this.local.getPort(), config.getCoreThreads(), config.getMaxThreads(), config.getThreadPoolName());
    }

    String getHostPort() {
        return this.local.getHostPort();
    }

    public SocketClusterStatus getStatus() {
        int currentGroupSize = 0;
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i].isOnline()) continue;
            ++currentGroupSize;
        }
        long txnIn = this.countIncoming.get();
        long txnOut = this.countOutgoing.get();
        return new SocketClusterStatus(currentGroupSize, txnIn, txnOut);
    }

    public void startup() {
        this.listener.startListening();
        this.register();
    }

    public void shutdown() {
        this.deregister();
        this.listener.shutdown();
    }

    private void register() {
        ClusterMessage h = ClusterMessage.register(this.local.getHostPort(), true);
        for (int i = 0; i < this.members.length; ++i) {
            boolean online = this.members[i].register(h);
            clusterLogger.info("Register as online with member [{}]", (Object)this.members[i].getHostPort(), (Object)online);
        }
    }

    private void send(SocketClient client, ClusterMessage msg) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("... send to member {} broadcast msg: {}", (Object)client, (Object)msg);
            }
            client.send(msg);
        }
        catch (Exception ex) {
            logger.error("Error sending message", (Throwable)ex);
            try {
                client.reconnect();
            }
            catch (IOException e) {
                logger.error("Error trying to reconnect", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMemberOnline(String fullName, boolean online) throws IOException {
        HashMap<String, SocketClient> hashMap = this.clientMap;
        synchronized (hashMap) {
            clusterLogger.info("Cluster member [{}] online[{}]", (Object)fullName, (Object)online);
            SocketClient member = this.clientMap.get(fullName);
            member.setOnline(online);
        }
    }

    public void broadcast(RemoteTransactionEvent remoteTransEvent) {
        try {
            this.countOutgoing.incrementAndGet();
            byte[] data = this.messageReadWrite.write(remoteTransEvent);
            ClusterMessage msg = ClusterMessage.transEvent(data);
            this.broadcast(msg);
        }
        catch (Exception e) {
            logger.error("Error sending RemoteTransactionEvent " + remoteTransEvent + " to cluster members.", (Throwable)e);
        }
    }

    private void broadcast(ClusterMessage msg) {
        for (int i = 0; i < this.members.length; ++i) {
            this.send(this.members[i], msg);
        }
    }

    private void deregister() {
        clusterLogger.info("Leaving cluster");
        ClusterMessage h = ClusterMessage.register(this.local.getHostPort(), false);
        this.broadcast(h);
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].disconnect();
        }
    }

    boolean process(SocketConnection request) throws ClassNotFoundException {
        try {
            ClusterMessage message = ClusterMessage.read(request.getDataInputStream());
            if (logger.isTraceEnabled()) {
                logger.trace("... received msg: {}", (Object)message);
            }
            if (message.isRegisterEvent()) {
                this.setMemberOnline(message.getRegisterHost(), message.isRegister());
            } else {
                this.countIncoming.incrementAndGet();
                RemoteTransactionEvent transEvent = this.messageReadWrite.read(message.getData());
                transEvent.run();
            }
            return message.isRegisterEvent() && !message.isRegister();
        }
        catch (InterruptedIOException e) {
            logger.info("Timeout waiting for message", (Throwable)e);
            try {
                request.disconnect();
            }
            catch (IOException ex) {
                logger.info("Error disconnecting after timeout", (Throwable)ex);
            }
            return true;
        }
        catch (EOFException e) {
            logger.debug("EOF disconnecting");
            return true;
        }
        catch (IOException e) {
            logger.info("IO Error waiting/reading message", (Throwable)e);
            return true;
        }
    }

    private InetSocketAddress parseFullName(String hostAndPort) {
        try {
            hostAndPort = hostAndPort.trim();
            int colonPos = hostAndPort.indexOf(":");
            if (colonPos == -1) {
                String msg = "No colon \":\" in " + hostAndPort;
                throw new IllegalArgumentException(msg);
            }
            String host = hostAndPort.substring(0, colonPos);
            String sPort = hostAndPort.substring(colonPos + 1, hostAndPort.length());
            int port = Integer.parseInt(sPort);
            return new InetSocketAddress(host, port);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing [" + hostAndPort + "] for the form [host:port]", ex);
        }
    }
}

