/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.socket;

import com.avaje.ebeaninternal.server.cluster.message.ClusterMessage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketClient {
    private static final Logger logger = LoggerFactory.getLogger(SocketClient.class);
    private final InetSocketAddress address;
    private final String hostPort;
    private final ReentrantLock lock = new ReentrantLock(false);
    private boolean online;
    private Socket socket;
    private OutputStream os;
    private DataOutputStream dataOutput;

    SocketClient(InetSocketAddress address) {
        this.address = address;
        this.hostPort = address.getHostName() + ":" + address.getPort();
    }

    public String toString() {
        return this.address.toString();
    }

    String getHostPort() {
        return this.hostPort;
    }

    int getPort() {
        return this.address.getPort();
    }

    boolean isOnline() {
        return this.online;
    }

    void setOnline(boolean online) throws IOException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (online) {
                this.setOnline();
            } else {
                this.disconnect();
            }
        }
        finally {
            lock.unlock();
        }
    }

    void reconnect() throws IOException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.disconnect();
            this.connect();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        block5: {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.online = false;
                if (this.socket == null) break block5;
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    String msg = "Error disconnecting from Cluster member " + this.hostPort;
                    logger.info(msg, (Throwable)e);
                }
                this.os = null;
                this.dataOutput = null;
                this.socket = null;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register(ClusterMessage registerMsg) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.setOnline();
            this.send(registerMsg);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    void send(ClusterMessage msg) throws IOException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.online) {
                msg.write(this.dataOutput);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void setOnline() throws IOException {
        this.connect();
        this.online = true;
    }

    private void connect() throws IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already got a socket connection?");
        }
        Socket s = new Socket();
        s.setKeepAlive(true);
        s.connect(this.address);
        this.socket = s;
        this.os = this.socket.getOutputStream();
        this.dataOutput = new DataOutputStream(this.os);
    }
}

