/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.socket;

import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.socket.SocketConnection;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RequestProcessor.class);
    private final Socket clientSocket;
    private final SocketClusterBroadcast owner;
    private final String hostPort;

    public RequestProcessor(SocketClusterBroadcast owner, Socket clientSocket) {
        this.clientSocket = clientSocket;
        this.owner = owner;
        this.hostPort = owner.getHostPort();
    }

    @Override
    public void run() {
        try {
            logger.trace("start listening for cluster messages");
            SocketConnection sc = new SocketConnection(this.clientSocket);
            while (!this.owner.process(sc)) {
            }
            logger.trace("disconnecting: {}", (Object)this.hostPort);
            sc.disconnect();
        }
        catch (Exception e) {
            logger.error("Error listening for messages - " + this.owner.getHostPort(), (Throwable)e);
        }
    }
}

