/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClusterMessage {
    private final String registerHost;
    private final boolean register;
    private final byte[] data;

    public static ClusterMessage register(String registerHost, boolean register) {
        return new ClusterMessage(registerHost, register);
    }

    public static ClusterMessage transEvent(byte[] data) {
        return new ClusterMessage(data);
    }

    private ClusterMessage(String registerHost, boolean register) {
        this.registerHost = registerHost;
        this.register = register;
        this.data = null;
    }

    private ClusterMessage(byte[] data) {
        this.data = data;
        this.registerHost = null;
        this.register = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.registerHost != null) {
            sb.append("register ");
            sb.append(this.register);
            sb.append(" ");
            sb.append(this.registerHost);
        } else {
            sb.append("transEvent ");
        }
        return sb.toString();
    }

    public boolean isRegisterEvent() {
        return this.registerHost != null;
    }

    public String getRegisterHost() {
        return this.registerHost;
    }

    public boolean isRegister() {
        return this.register;
    }

    public byte[] getData() {
        return this.data;
    }

    public void write(DataOutputStream dataOutput) throws IOException {
        boolean dataMessage = this.data != null;
        dataOutput.writeBoolean(dataMessage);
        if (dataMessage) {
            dataOutput.writeInt(this.data.length);
            dataOutput.write(this.data);
        } else {
            dataOutput.writeUTF(this.getRegisterHost());
            dataOutput.writeBoolean(this.isRegister());
        }
        dataOutput.flush();
    }

    public static ClusterMessage read(DataInputStream dataInput) throws IOException {
        boolean dataMessage = dataInput.readBoolean();
        if (dataMessage) {
            int length = dataInput.readInt();
            byte[] data = new byte[length];
            dataInput.readFully(data);
            return new ClusterMessage(data);
        }
        String host = dataInput.readUTF();
        boolean registered = dataInput.readBoolean();
        return new ClusterMessage(host, registered);
    }
}

