/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.message;

import com.avaje.ebeaninternal.server.cluster.BinaryMessage;
import com.avaje.ebeaninternal.server.cluster.BinaryMessageList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class BinaryDataWriter {
    private final BinaryMessageList messageList;
    private final ByteArrayOutputStream buffer;
    private final DataOutputStream dataOut;
    private final String serverName;

    BinaryDataWriter(String serverName, BinaryMessageList messageList) {
        this.serverName = serverName;
        this.messageList = messageList;
        this.buffer = new ByteArrayOutputStream(256);
        this.dataOut = new DataOutputStream(this.buffer);
    }

    byte[] write() throws IOException {
        this.dataOut.writeUTF(this.serverName);
        for (BinaryMessage msg : this.messageList.getList()) {
            this.write(msg);
        }
        this.dataOut.writeBoolean(false);
        this.dataOut.flush();
        return this.buffer.toByteArray();
    }

    private void write(BinaryMessage msg) throws IOException {
        this.dataOut.writeBoolean(true);
        this.dataOut.write(msg.getByteArray());
    }
}

