/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.message;

import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIds;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

class BinaryDataReader {
    private final ClusterManager clusterManager;
    private final DataInputStream dataInput;
    private SpiEbeanServer server;
    private RemoteTransactionEvent event;

    BinaryDataReader(ClusterManager clusterManager, byte[] data) {
        this.clusterManager = clusterManager;
        this.dataInput = new DataInputStream(new ByteArrayInputStream(data));
    }

    RemoteTransactionEvent read() throws IOException {
        String serverName = this.dataInput.readUTF();
        this.server = (SpiEbeanServer)this.clusterManager.getServer(serverName);
        if (this.server == null) {
            throw new IllegalStateException("EbeanServer not found for name [" + serverName + "]");
        }
        this.event = new RemoteTransactionEvent(this.server);
        boolean more = this.dataInput.readBoolean();
        while (more) {
            this.readMessage();
            more = this.dataInput.readBoolean();
        }
        return this.event;
    }

    private void readMessage() throws IOException {
        int msgType = this.dataInput.readInt();
        switch (msgType) {
            case 1: {
                this.event.addBeanPersistIds(BeanPersistIds.readBinaryMessage((SpiEbeanServer)this.server, (DataInput)this.dataInput));
                break;
            }
            case 2: {
                this.event.addTableIUD(TransactionEventTable.TableIUD.readBinaryMessage((DataInput)this.dataInput));
                break;
            }
            default: {
                throw new RuntimeException("Invalid Transaction msgType " + msgType);
            }
        }
    }
}

