/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SocketConfig {
    private String localHostPort;
    private List<String> members = new ArrayList<String>();
    private int coreThreads = 2;
    private int maxThreads = 16;
    private String threadPoolName = "EbeanCluster";
    private Properties properties;

    public String getLocalHostPort() {
        return this.localHostPort;
    }

    public void setLocalHostPort(String localHostPort) {
        this.localHostPort = localHostPort;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void loadFromProperties(Properties properties) {
        String[] split;
        this.properties = properties;
        this.threadPoolName = this.getProperty("ebean.cluster.threadPoolName", this.threadPoolName);
        this.localHostPort = this.getProperty("ebean.cluster.localHostPort", this.localHostPort);
        this.coreThreads = this.getInt("ebean.cluster.coreThreads", this.coreThreads);
        this.maxThreads = this.getInt("ebean.cluster.maxThreads", this.maxThreads);
        String rawMembers = this.getProperty("ebean.cluster.members", "");
        for (String rawMember : split = rawMembers.split("[,;]")) {
            this.members.add(rawMember.trim());
        }
    }

    private int getInt(String key, int value) {
        return Integer.parseInt(this.getProperty(key, Integer.toString(value)));
    }

    private String getProperty(String key, String defaultValue) {
        String value = this.properties.getProperty(key.toLowerCase());
        if (value != null) {
            return value.trim();
        }
        value = this.properties.getProperty(key, defaultValue);
        return value == null ? null : value.trim();
    }
}

