/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AgentManifestReader {
    private final Set<String> packageSet = new HashSet<String>();

    public AgentManifestReader(Set<String> initialPackages) {
        if (initialPackages != null) {
            this.packageSet.addAll(initialPackages);
        }
    }

    public AgentManifestReader() {
    }

    public void read(File file) {
        if (file.exists()) {
            try {
                this.read(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading META-INF/ebean.mf manifest file", e);
            }
        }
    }

    public void read(InputStream is) throws IOException {
        this.read(new Manifest(is));
    }

    public void read(Manifest man) throws IOException {
        Attributes attributes = man.getMainAttributes();
        String packages = attributes.getValue("packages");
        if (packages != null) {
            this.addRaw(packages);
        }
    }

    public void addRaw(String content) {
        if (content != null) {
            this.add(content.replace("packages:", "").trim());
        }
    }

    public Set<String> getPackages() {
        return this.packageSet;
    }

    public void readManifests(ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                Enumeration<URL> resources = classLoader.getResources("META-INF/ebean.mf");
                while (resources.hasMoreElements()) {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    this.add(attributes.getValue("packages"));
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error reading META-INF/ebean.mf manifest resources");
            e.printStackTrace();
        }
    }

    private void add(String packages) {
        String[] split = packages.split(",|;| ");
        for (int i = 0; i < split.length; ++i) {
            String pkg = split[i].trim();
            if (pkg.isEmpty()) continue;
            this.packageSet.add(pkg);
        }
    }
}

