/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class IgnoreClassHelper {
    private static final Set<String> ignoreOneLevel = new HashSet<String>();
    private static final Set<String> ignoreTwoLevel = new HashSet<String>();
    private static final Set<String> ignoreThreeLevel = new HashSet<String>();
    private final String[] processPackages;

    public IgnoreClassHelper(Collection<String> packages) {
        ArrayList<String> packageList = new ArrayList<String>();
        if (packages != null) {
            for (String aPackage : packages) {
                packageList.add(this.convertPackage(aPackage));
            }
        }
        this.processPackages = packageList.toArray(new String[packageList.size()]);
    }

    private String convertPackage(String pkg) {
        if ((pkg = pkg.trim().replace('.', '/')).endsWith("**")) {
            return pkg.substring(0, pkg.length() - 2);
        }
        if (pkg.endsWith("*")) {
            return pkg.substring(0, pkg.length() - 1);
        }
        if (pkg.endsWith("/")) {
            return pkg;
        }
        return pkg + "/";
    }

    private boolean specificMatching(String className) {
        for (int i = 0; i < this.processPackages.length; ++i) {
            if (!className.startsWith(this.processPackages[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnoreClass(String className) {
        if (className == null) {
            return true;
        }
        if ((className = className.replace('.', '/')).equals("com/avaje/ebean/Model")) {
            return false;
        }
        if (this.processPackages.length > 0) {
            return this.specificMatching(className);
        }
        if (className.startsWith("$")) {
            return true;
        }
        int firstSlash = className.indexOf(47);
        if (firstSlash == -1) {
            return true;
        }
        String firstPackage = className.substring(0, firstSlash);
        if (ignoreOneLevel.contains(firstPackage)) {
            return true;
        }
        int secondSlash = className.indexOf(47, firstSlash + 1);
        if (secondSlash == -1) {
            return false;
        }
        String secondPackage = className.substring(0, secondSlash);
        if (ignoreTwoLevel.contains(secondPackage)) {
            return true;
        }
        int thirdSlash = className.indexOf(47, secondSlash + 1);
        if (thirdSlash == -1) {
            return false;
        }
        String thirdPackage = className.substring(0, thirdSlash);
        return ignoreThreeLevel.contains(thirdPackage);
    }

    static {
        ignoreOneLevel.add("java");
        ignoreOneLevel.add("javax");
        ignoreOneLevel.add("play");
        ignoreOneLevel.add("sbt");
        ignoreOneLevel.add("scala");
        ignoreOneLevel.add("sun");
        ignoreOneLevel.add("sunw");
        ignoreOneLevel.add("oracle");
        ignoreOneLevel.add("groovy");
        ignoreOneLevel.add("kotlin");
        ignoreOneLevel.add("junit");
        ignoreOneLevel.add("microsoft");
        ignoreTwoLevel.add("com/sun");
        ignoreTwoLevel.add("org/aopalliance");
        ignoreTwoLevel.add("org/wc3");
        ignoreTwoLevel.add("org/xml");
        ignoreTwoLevel.add("org/junit");
        ignoreTwoLevel.add("org/apache");
        ignoreTwoLevel.add("org/eclipse");
        ignoreTwoLevel.add("org/jetbrains");
        ignoreTwoLevel.add("org/joda");
        ignoreTwoLevel.add("com/mysql");
        ignoreTwoLevel.add("org/postgresql");
        ignoreTwoLevel.add("org/h2");
        ignoreTwoLevel.add("com/h2database");
        ignoreTwoLevel.add("org/hsqldb");
        ignoreTwoLevel.add("org/ibex");
        ignoreTwoLevel.add("org/sqlite");
        ignoreTwoLevel.add("ch/qos");
        ignoreTwoLevel.add("org/slf4j");
        ignoreTwoLevel.add("org/codehaus");
        ignoreTwoLevel.add("com/fasterxml");
        ignoreTwoLevel.add("org/assertj");
        ignoreTwoLevel.add("org/hamcrest");
        ignoreTwoLevel.add("org/mockito");
        ignoreTwoLevel.add("org/objenesis");
        ignoreTwoLevel.add("org/objectweb");
        ignoreTwoLevel.add("org/jboss");
        ignoreTwoLevel.add("org/testng");
        ignoreTwoLevel.add("com/intellij");
        ignoreTwoLevel.add("com/google");
        ignoreTwoLevel.add("com/squareup");
        ignoreTwoLevel.add("com/microsoft");
        ignoreThreeLevel.add("com/avaje/ebeaninternal");
        ignoreThreeLevel.add("com/avaje/ebean");
        ignoreThreeLevel.add("org/avaje/ebean");
    }
}

