/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.dbmigration.ddl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.avaje.dbmigration.ddl.DdlRunnerException;

public class DdlParser {
    public List<String> parse(StringReader reader) {
        try {
            String s;
            BufferedReader br = new BufferedReader(reader);
            StatementsSeparator statements = new StatementsSeparator();
            while ((s = br.readLine()) != null) {
                s = s.trim();
                statements.nextLine(s);
            }
            return statements.statements;
        }
        catch (IOException e) {
            throw new DdlRunnerException(e);
        }
    }

    static class StatementsSeparator {
        ArrayList<String> statements = new ArrayList();
        boolean trimDelimiter;
        boolean inDbProcedure;
        StringBuilder sb = new StringBuilder();

        StatementsSeparator() {
        }

        void lineContainsDollars(String line) {
            if (this.inDbProcedure) {
                if (this.trimDelimiter) {
                    line = line.replace("$$", "");
                }
                this.endOfStatement(line);
            } else {
                this.trimDelimiter = line.equals("delimiter $$");
                if (!this.trimDelimiter) {
                    this.sb.append(line).append(" ");
                }
            }
            this.inDbProcedure = !this.inDbProcedure;
        }

        void endOfStatement(String line) {
            this.sb.append(line);
            this.statements.add(this.sb.toString().trim());
            this.sb = new StringBuilder();
        }

        void nextLine(String line) {
            if (line.contains("$$")) {
                this.lineContainsDollars(line);
                return;
            }
            if (this.sb.length() == 0 && (line.isEmpty() || line.startsWith("--"))) {
                return;
            }
            if (this.inDbProcedure) {
                this.sb.append(line).append(" ");
                return;
            }
            int semiPos = line.indexOf(59);
            if (semiPos == -1) {
                this.sb.append(line).append(" ");
            } else if (semiPos == line.length() - 1) {
                this.endOfStatement(line);
            } else {
                String preSemi = line.substring(0, semiPos);
                this.endOfStatement(preSemi);
                this.sb.append(line.substring(semiPos + 1));
            }
        }
    }
}

