/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner.internal.scanner.classpath;

import java.io.File;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import org.avaje.classpath.scanner.internal.UrlUtils;
import org.avaje.classpath.scanner.internal.scanner.classpath.ClassPathLocationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClassPathLocationScanner
implements ClassPathLocationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemClassPathLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        String filePath = UrlUtils.toFilePath(locationUrl);
        File folder = new File(filePath);
        if (!folder.isDirectory()) {
            LOG.debug("Skipping path as it is not a directory: " + filePath);
            return new TreeSet<String>();
        }
        String classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!classPathRootOnDisk.endsWith(File.separator)) {
            classPathRootOnDisk = classPathRootOnDisk + File.separator;
        }
        LOG.debug("Scanning starting at classpath root in filesystem: " + classPathRootOnDisk);
        return this.findResourceNamesFromFileSystem(classPathRootOnDisk, location, folder);
    }

    Set<String> findResourceNamesFromFileSystem(String classPathRootOnDisk, String scanRootLocation, File folder) {
        LOG.debug("Scanning for resources in path: {} ({})", (Object)folder.getPath(), (Object)scanRootLocation);
        TreeSet<String> resourceNames = new TreeSet<String>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead()) continue;
                String resourcePath = this.toResourceNameOnClasspath(classPathRootOnDisk, file);
                if (file.isDirectory()) {
                    if (this.ignorePath(resourcePath)) continue;
                    resourceNames.addAll(this.findResourceNamesFromFileSystem(classPathRootOnDisk, scanRootLocation, file));
                    continue;
                }
                resourceNames.add(resourcePath);
            }
        }
        return resourceNames;
    }

    private boolean ignorePath(String resourcePath) {
        return resourcePath.startsWith("org/avaje/classpath") || resourcePath.startsWith("io/ebean");
    }

    private String toResourceNameOnClasspath(String classPathRootOnDisk, File file) {
        String fileName = file.getAbsolutePath().replace("\\", "/");
        return fileName.substring(classPathRootOnDisk.length());
    }
}

