/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner.internal.scanner.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.avaje.classpath.scanner.Resource;
import org.avaje.classpath.scanner.core.ClassPathScanException;
import org.avaje.classpath.scanner.internal.FileCopyUtils;

class ClassPathResource
implements Comparable<ClassPathResource>,
Resource {
    private final String location;
    private final ClassLoader classLoader;

    public ClassPathResource(String location, ClassLoader classLoader) {
        this.location = location;
        this.classLoader = classLoader;
    }

    public String toString() {
        return this.location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLocationOnDisk() {
        URL url = this.getUrl();
        if (url == null) {
            throw new ClassPathScanException("Unable to location resource on disk: " + this.location);
        }
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new ClassPathScanException("Unknown encoding: UTF-8", e);
        }
    }

    private URL getUrl() {
        return this.classLoader.getResource(this.location);
    }

    public String loadAsString(String encoding) {
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new ClassPathScanException("Unable to obtain inputstream for resource: " + this.location);
            }
            InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(encoding));
            return FileCopyUtils.copyToString(reader);
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load resource: " + this.location + " (encoding: " + encoding + ")", e);
        }
    }

    public byte[] loadAsBytes() {
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new ClassPathScanException("Unable to obtain inputstream for resource: " + this.location);
            }
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load resource: " + this.location, e);
        }
    }

    public String getFilename() {
        return this.location.substring(this.location.lastIndexOf("/") + 1);
    }

    public boolean exists() {
        return this.getUrl() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Override
    public int compareTo(ClassPathResource o) {
        return this.location.compareTo(o.location);
    }
}

