/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner.internal.scanner.classpath;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.avaje.classpath.scanner.ClassFilter;
import org.avaje.classpath.scanner.ClassPathScanException;
import org.avaje.classpath.scanner.FilterResource;
import org.avaje.classpath.scanner.Location;
import org.avaje.classpath.scanner.Resource;
import org.avaje.classpath.scanner.ResourceFilter;
import org.avaje.classpath.scanner.internal.EnvironmentDetection;
import org.avaje.classpath.scanner.internal.ResourceAndClassScanner;
import org.avaje.classpath.scanner.internal.UrlUtils;
import org.avaje.classpath.scanner.internal.scanner.classpath.ClassPathLocationScanner;
import org.avaje.classpath.scanner.internal.scanner.classpath.ClassPathResource;
import org.avaje.classpath.scanner.internal.scanner.classpath.DefaultUrlResolver;
import org.avaje.classpath.scanner.internal.scanner.classpath.FileSystemClassPathLocationScanner;
import org.avaje.classpath.scanner.internal.scanner.classpath.JarFileClassPathLocationScanner;
import org.avaje.classpath.scanner.internal.scanner.classpath.OsgiClassPathLocationScanner;
import org.avaje.classpath.scanner.internal.scanner.classpath.UrlResolver;
import org.avaje.classpath.scanner.internal.scanner.classpath.jboss.JBossVFSv2UrlResolver;
import org.avaje.classpath.scanner.internal.scanner.classpath.jboss.JBossVFSv3ClassPathLocationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathScanner
implements ResourceAndClassScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanner.class);
    private final ClassLoader classLoader;
    private final Map<Location, List<URL>> locationUrlCache = new HashMap<Location, List<URL>>();
    private final Map<String, ClassPathLocationScanner> locationScannerCache = new HashMap<String, ClassPathLocationScanner>();
    private final Map<ClassPathLocationScanner, Map<URL, Set<String>>> resourceNameCache = new HashMap<ClassPathLocationScanner, Map<URL, Set<String>>>();

    public ClassPathScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public List<Resource> scanForResources(Location path, ResourceFilter predicate) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Set<String> resourceNames = this.findResourceNames(path, predicate);
            for (String resourceName : resourceNames) {
                resources.add(new ClassPathResource(resourceName, this.classLoader));
                LOG.trace("... found resource: {}", (Object)resourceName);
            }
            return resources;
        }
        catch (IOException e) {
            throw new ClassPathScanException(e);
        }
    }

    @Override
    public List<Class<?>> scanForClasses(Location location, ClassFilter predicate) {
        try {
            ArrayList classes = new ArrayList();
            Set<String> resourceNames = this.findResourceNames(location, FilterResource.bySuffix((String)".class"));
            LOG.debug("scanning for classes at {} found {} resources to check", (Object)location, (Object)resourceNames.size());
            for (String resourceName : resourceNames) {
                String className = this.toClassName(resourceName);
                try {
                    Class<?> clazz = this.classLoader.loadClass(className);
                    if (!predicate.isMatch(clazz)) continue;
                    classes.add(clazz);
                    LOG.trace("... matched class: {} ", (Object)className);
                }
                catch (NoClassDefFoundError err) {
                    LOG.debug("... class " + className + " could not be loaded and will be ignored.", (Throwable)err);
                }
            }
            return classes;
        }
        catch (IOException e) {
            throw new ClassPathScanException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ClassPathScanException(e);
        }
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(Location location, ResourceFilter predicate) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        List<URL> locationsUrls = this.getLocationUrlsForPath(location);
        for (URL locationUrl : locationsUrls) {
            LOG.debug("scanning URL: {}", (Object)locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String protocol = resolvedUrl.getProtocol();
            ClassPathLocationScanner classPathLocationScanner = this.createLocationScanner(protocol);
            if (classPathLocationScanner == null) {
                String scanRoot = UrlUtils.toFilePath(resolvedUrl);
                LOG.warn("Unable to scan location: {} (unsupported protocol: {})", (Object)scanRoot, (Object)protocol);
                continue;
            }
            Set<String> names = this.resourceNameCache.get(classPathLocationScanner).get(resolvedUrl);
            if (names == null) {
                names = classPathLocationScanner.findResourceNames(location.getPath(), resolvedUrl);
                this.resourceNameCache.get(classPathLocationScanner).put(resolvedUrl, names);
            }
            resourceNames.addAll(names);
        }
        return this.filterResourceNames(resourceNames, predicate);
    }

    private List<URL> getLocationUrlsForPath(Location location) throws IOException {
        if (this.locationUrlCache.containsKey(location)) {
            return this.locationUrlCache.get(location);
        }
        LOG.debug("determining location urls for {} using ClassLoader {} ...", (Object)location, (Object)this.classLoader);
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        if (this.classLoader.getClass().getName().startsWith("com.ibm")) {
            Enumeration<URL> urls = this.classLoader.getResources(location.toString());
            if (!urls.hasMoreElements()) {
                LOG.warn("Unable to resolve location " + location);
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                locationUrls.add(new URL(URLDecoder.decode(url.toExternalForm(), "UTF-8")));
            }
        } else {
            Enumeration<URL> urls = this.classLoader.getResources(location.getPath());
            if (!urls.hasMoreElements()) {
                LOG.warn("Unable to resolve location " + location);
            }
            while (urls.hasMoreElements()) {
                locationUrls.add(urls.nextElement());
            }
        }
        this.locationUrlCache.put(location, locationUrls);
        return locationUrls;
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (new EnvironmentDetection(this.classLoader).isJBossVFSv2() && protocol.startsWith("vfs")) {
            return new JBossVFSv2UrlResolver();
        }
        return new DefaultUrlResolver();
    }

    private ClassPathLocationScanner createLocationScanner(String protocol) {
        if (this.locationScannerCache.containsKey(protocol)) {
            return this.locationScannerCache.get(protocol);
        }
        if ("file".equals(protocol)) {
            FileSystemClassPathLocationScanner locationScanner = new FileSystemClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) {
            JarFileClassPathLocationScanner locationScanner = new JarFileClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        EnvironmentDetection featureDetector = new EnvironmentDetection(this.classLoader);
        if (featureDetector.isJBossVFSv3() && "vfs".equals(protocol)) {
            JBossVFSv3ClassPathLocationScanner locationScanner = new JBossVFSv3ClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        if (featureDetector.isOsgi() && ("bundle".equals(protocol) || "bundleresource".equals(protocol))) {
            OsgiClassPathLocationScanner locationScanner = new OsgiClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        return null;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, ResourceFilter predicate) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            if (!predicate.isMatch(resourceName)) continue;
            filteredResourceNames.add(resourceName);
        }
        return filteredResourceNames;
    }
}

