/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.util;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.OptionsBuilder;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketLoader {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketLoader.class);

    public static void main(String[] s) throws InterruptedException, IOException {
        if (s.length == 0) {
            s = new String[]{"5", "5000", "1", "http://127.0.0.1:8080/"};
        }
        int run = Integer.valueOf(s[0]);
        int clientNum = Integer.valueOf(s[1]);
        final int messageNum = Integer.valueOf(s[2]);
        String url = "http://" + s[3];
        System.out.println("Stressing: " + url);
        System.out.println("Number of Client: " + clientNum);
        System.out.println("Number of Message: " + messageNum);
        System.out.println("Number of run: " + run);
        long count = 0L;
        for (int r = 0; r < run; ++r) {
            DefaultAsyncHttpClientConfig.Builder b = new DefaultAsyncHttpClientConfig.Builder();
            b.setFollowRedirect(true).setConnectTimeout(-1).setReadTimeout(-1).setUserAgent("loader/1.1").setTcpNoDelay(true).setKeepAlive(true);
            DefaultAsyncHttpClient c = new DefaultAsyncHttpClient((AsyncHttpClientConfig)b.build());
            Client<? extends Options, ? extends OptionsBuilder, ? extends RequestBuilder> client = ClientFactory.getDefault().newClient();
            RequestBuilder request = client.newRequestBuilder();
            ((RequestBuilder)request.method(Request.METHOD.GET)).uri(url);
            request.transport(Request.TRANSPORT.WEBSOCKET);
            request.header("Sec-WebSocket-Protocol", "rpm-protocol");
            final CountDownLatch l = new CountDownLatch(clientNum);
            final CountDownLatch messages = new CountDownLatch(messageNum * clientNum);
            long clientCount = l.getCount();
            final AtomicLong total = new AtomicLong(0L);
            Socket[] sockets = new Socket[clientNum];
            int i = 0;
            while ((long)i < clientCount) {
                final AtomicLong start = new AtomicLong(0L);
                sockets[i] = client.create((Options)((OptionsBuilder)((OptionsBuilder)client.newOptionsBuilder().runtime((AsyncHttpClient)c)).reconnect(false)).build()).on(new Function<Integer>(){

                    @Override
                    public void on(Integer statusCode) {
                        start.set(System.currentTimeMillis());
                        l.countDown();
                    }
                }).on(new Function<String>(){
                    int mCount = 0;

                    @Override
                    public void on(String s) {
                        if (s.startsWith("message")) {
                            String[] m = s.split("\n\r");
                            this.mCount += m.length;
                            messages.countDown();
                            if (this.mCount == messageNum) {
                                total.addAndGet(System.currentTimeMillis() - start.get());
                            }
                        }
                    }
                }).on(new Function<Throwable>(){

                    @Override
                    public void on(Throwable t) {
                        t.printStackTrace();
                    }
                });
                ++i;
            }
            i = 0;
            while ((long)i < clientCount) {
                sockets[i].open(request.build());
                ++i;
            }
            l.await(30L, TimeUnit.SECONDS);
            System.out.println("OK, all Connected: " + clientNum);
            i = 0;
            while ((long)i < clientCount) {
                for (int j = 0; j < messageNum; ++j) {
                    sockets[i].fire("message" + i);
                }
                ++i;
            }
            messages.await(1L, TimeUnit.HOURS);
            i = 0;
            while ((long)i < clientCount) {
                sockets[i].close();
                ++i;
            }
            count += total.get() / clientCount;
            System.out.println("Run " + r + " => Total run : " + total.get() / clientCount);
            c.close();
            System.gc();
        }
        System.out.println("=== Means " + count / (long)run + "=====");
    }
}

