/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync;

import com.ning.http.client.AsyncHttpClient;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Transport;

public abstract class OptionsBuilder<U extends Options, T extends OptionsBuilder<U, T>> {
    private Transport transport;
    private boolean reconnect = true;
    private int reconnectInSecond = 0;
    private long waitBeforeUnlocking = 2000L;
    private AsyncHttpClient client;
    private boolean runtimeShared = false;
    private int requestTimeout = -1;
    protected final Class<T> derived;

    protected OptionsBuilder(Class<T> derived) {
        this.derived = derived;
    }

    public T requestTimeoutInSeconds(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public T registerTransport(Transport transport) {
        this.transport = transport;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public T reconnect(boolean reconnect) {
        this.reconnect = reconnect;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public T pauseBeforeReconnectInSeconds(int reconnectInSecond) {
        this.reconnectInSecond = reconnectInSecond;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public T waitBeforeUnlocking(long waitBeforeUnlocking) {
        this.waitBeforeUnlocking = waitBeforeUnlocking;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public T runtimeShared(boolean runtimeShared) {
        this.runtimeShared = runtimeShared;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public T runtime(AsyncHttpClient client) {
        return this.runtime(client, true);
    }

    public T runtime(AsyncHttpClient client, boolean runtimeShared) {
        this.client = client;
        this.runtimeShared = runtimeShared;
        return (T)((OptionsBuilder)this.derived.cast(this));
    }

    public abstract U build();

    public Transport transport() {
        return this.transport;
    }

    public boolean reconnect() {
        return this.reconnect;
    }

    public int reconnectInSeconds() {
        return this.reconnectInSecond;
    }

    public long waitBeforeUnlocking() {
        return this.waitBeforeUnlocking;
    }

    public AsyncHttpClient runtime() {
        return this.client;
    }

    public boolean runtimeShared() {
        return this.runtimeShared;
    }

    public int requestTimeoutInSeconds() {
        return this.requestTimeout;
    }
}

