/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.util;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.OptionsBuilder;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketLoader {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketLoader.class);

    public static void main(String[] s) throws InterruptedException, IOException {
        int i;
        if (s.length == 0) {
            s = new String[]{"1", "10000", "http://10.0.1.4:8080/default/test"};
        }
        int clientNum = Integer.valueOf(s[0]);
        final int messageNum = Integer.valueOf(s[1]);
        String url = s[2];
        System.out.println("Connecting to: " + s[2]);
        System.out.println("Number of Client: " + clientNum);
        System.out.println("Number of Message: " + messageNum);
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        b.setFollowRedirects(true).setIdleConnectionTimeoutInMs(-1).setRequestTimeoutInMs(-1).setConnectionTimeoutInMs(600000);
        AsyncHttpClient c = new AsyncHttpClient(b.build());
        final CountDownLatch l = new CountDownLatch(clientNum);
        final CountDownLatch messages = new CountDownLatch(messageNum * clientNum);
        Client<? extends Options, ? extends OptionsBuilder, ? extends RequestBuilder> client = ClientFactory.getDefault().newClient();
        RequestBuilder request = client.newRequestBuilder();
        ((RequestBuilder)request.method(Request.METHOD.GET)).uri(url);
        request.transport(Request.TRANSPORT.WEBSOCKET);
        long clientCount = l.getCount();
        final AtomicLong total = new AtomicLong(0L);
        final AtomicLong completed = new AtomicLong(0L);
        final AtomicInteger cc = new AtomicInteger();
        Socket[] sockets = new Socket[clientNum];
        int i2 = 0;
        while ((long)i2 < clientCount) {
            final AtomicLong start = new AtomicLong(0L);
            sockets[i2] = client.create((Options)((OptionsBuilder)((OptionsBuilder)client.newOptionsBuilder().runtime(c)).reconnect(false)).build()).on(new Function<Integer>(){

                @Override
                public void on(Integer statusCode) {
                    start.set(System.currentTimeMillis());
                    System.out.println("Connected clients: " + cc.getAndIncrement());
                    l.countDown();
                }
            }).on(new Function<String>(){
                int mCount = 0;

                @Override
                public void on(String s) {
                    if (s.startsWith("message")) {
                        String[] m = s.split("\n\r");
                        this.mCount += m.length;
                        messages.countDown();
                        if (this.mCount == messageNum) {
                            System.out.println("All messages received " + this.mCount + " Completed: " + completed.incrementAndGet());
                            total.addAndGet(System.currentTimeMillis() - start.get());
                        }
                    }
                }
            }).on(new Function<Throwable>(){

                @Override
                public void on(Throwable t) {
                    t.printStackTrace();
                }
            });
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < clientCount) {
            sockets[i2].open(request.build());
            ++i2;
        }
        l.await(60L, TimeUnit.SECONDS);
        System.out.println("OK, all Connected: " + clientNum);
        Socket socket = client.create((Options)((OptionsBuilder)client.newOptionsBuilder().runtime(c)).build());
        socket.open(request.build());
        for (i = 0; i < messageNum; ++i) {
            socket.fire("message" + i);
        }
        messages.await();
        socket.close();
        i = 0;
        while ((long)i < clientCount) {
            sockets[i].close();
            ++i;
        }
        c.close();
        System.out.println("Total: " + total.get() / clientCount);
    }
}

