/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import java.util.List;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.util.TypeResolver;

public class TransportsUtil {
    static void invokeFunction(List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        String originalMessage = instanceType.toString();
        for (FunctionWrapper wrapper : functions) {
            Function<?> f = wrapper.function();
            Class<?>[] typeArguments = TypeResolver.resolveArguments(f.getClass(), Function.class);
            if (typeArguments.length > 0) {
                instanceType = TransportsUtil.matchDecoder(instanceType, decoders);
                implementedType = instanceType.getClass();
            }
            if (typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(implementedType) || !resolver.resolve(originalMessage, functionName, wrapper)) continue;
            f.on(instanceType);
        }
    }

    static Object matchDecoder(Object instanceType, List<Decoder<? extends Object, ?>> decoders) {
        for (Decoder<Object, ?> d : decoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(d.getClass(), Decoder.class);
            if (typeArguments.length <= 0 || !typeArguments[0].equals(instanceType.getClass())) continue;
            instanceType = d.decode(instanceType);
        }
        return instanceType;
    }
}

