/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import java.util.List;
import java.util.Map;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;

public class StreamTransport<T>
implements AsyncHandler<String>,
Transport {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    protected Future f;
    protected final List<FunctionWrapper> functions;
    private final List<Decoder<? extends Object, ?>> decoders;
    protected String charSet = "ISO-8859-1";
    private final FunctionResolver resolver;
    private final Options options;

    public StreamTransport(Options options, List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, FunctionResolver resolver) {
        if (decoders.size() == 0) {
            decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(String s) {
                    return s;
                }
            });
        }
        this.decoders = decoders;
        this.functions = functions;
        this.resolver = resolver;
        this.options = options;
    }

    @Override
    public Transport future(Future f) {
        this.f = f;
        return this;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public void onThrowable(Throwable t) {
        TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Function.MESSAGE.error.name(), this.resolver);
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
        if (!m.isEmpty()) {
            TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Function.MESSAGE.message.name(), this.resolver);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Map.class, headers.getHeaders(), Function.MESSAGE.headers.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.f.done();
        TransportsUtil.invokeFunction(this.decoders, this.functions, String.class, "Open", Function.MESSAGE.open.name(), this.resolver);
        TransportsUtil.invokeFunction(this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Function.MESSAGE.status.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public String onCompleted() throws Exception {
        return "";
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.STREAMING;
    }

    @Override
    public void close() {
        TransportsUtil.invokeFunction(this.decoders, this.functions, String.class, "Close", Function.MESSAGE.open.name(), this.resolver);
    }

    @Override
    public boolean canHandle(Request request) {
        return true;
    }
}

