/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync;

import org.atmosphere.wasync.Transport;

public class Options {
    private final OptionsBuilder b;

    private Options(OptionsBuilder b) {
        this.b = b;
    }

    public Transport transport() {
        return this.b.transport;
    }

    public boolean reconnect() {
        return this.b.reconnect;
    }

    public int reconnectInSeconds() {
        return this.b.reconnectInSecond;
    }

    public long waitBeforeUnlocking() {
        return this.b.waitBeforeUnlocking;
    }

    public static final class OptionsBuilder {
        private Transport transport;
        private boolean reconnect = true;
        private int reconnectInSecond = 1;
        public long waitBeforeUnlocking = 2500L;

        public OptionsBuilder registerTransport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public OptionsBuilder reconnect(boolean reconnect) {
            this.reconnect = reconnect;
            return this;
        }

        public OptionsBuilder pauseBeforeReconnectInSeconds(int reconnectInSecond) {
            this.reconnectInSecond = reconnectInSecond;
            return this;
        }

        public OptionsBuilder waitBeforeUnlocking(long waitBeforeUnlocking) {
            this.waitBeforeUnlocking = waitBeforeUnlocking;
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

