/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransport
implements AsyncHandler<String>,
Transport {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(StreamTransport.class);
    protected final List<FunctionWrapper> functions;
    protected final List<Decoder<? extends Object, ?>> decoders;
    protected String charSet = "UTF-8";
    protected final FunctionResolver resolver;
    protected final Options options;
    protected final RequestBuilder requestBuilder;
    protected final Request request;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final boolean isBinary;
    protected Socket.STATUS status = Socket.STATUS.INIT;
    protected final AtomicBoolean errorHandled = new AtomicBoolean();
    protected ListenableFuture underlyingFuture;
    protected boolean protocolReceived = false;
    protected Future connectdFuture;
    protected final boolean protocolEnabled;

    public StreamTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
        this.request = request;
        this.protocolEnabled = request.queryString().get("X-atmo-protocol") != null;
        this.isBinary = request.headers().get("Content-Type") != null ? request.headers().get("Content-Type").contains("application/octet-stream") : false;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public void onThrowable(Throwable t) {
        if (CancellationException.class.isAssignableFrom(t.getClass())) {
            return;
        }
        this.logger.warn("", t);
        this.status = Socket.STATUS.ERROR;
        this.errorHandled.set(TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (this.isBinary) {
            byte[] payload = bodyPart.getBodyPartBytes();
            if (!StreamTransport.whiteSpace(payload)) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
            }
        } else {
            String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
            if (m.length() > 0) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
            }
        }
        if (this.connectdFuture != null) {
            this.connectdFuture.done();
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(Event.HEADERS, this.decoders, this.functions, Map.class, headers.getHeaders(), Event.HEADERS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        TransportsUtil.invokeFunction(Event.TRANSPORT, this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
        this.errorHandled.set(false);
        this.closed.set(false);
        Event newStatus = this.status.equals((Object)Socket.STATUS.INIT) ? Event.OPEN : Event.REOPENED;
        TransportsUtil.invokeFunction(newStatus, this.decoders, this.functions, String.class, newStatus.name(), newStatus.name(), this.resolver);
        TransportsUtil.invokeFunction(Event.MESSAGE, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public String onCompleted() throws Exception {
        if (this.closed.get()) {
            return "";
        }
        if (this.status == Socket.STATUS.ERROR) {
            return "";
        }
        this.close();
        if (this.options.reconnect()) {
            this.status = Socket.STATUS.REOPENED;
            if (this.options.reconnectInSeconds() > 0) {
                ScheduledExecutorService e = this.options.runtime().getConfig().reaper();
                e.schedule(new Runnable(){

                    @Override
                    public void run() {
                        StreamTransport.this.reconnect();
                    }
                }, (long)this.options.reconnectInSeconds(), TimeUnit.SECONDS);
            } else {
                this.reconnect();
            }
        }
        return "";
    }

    void reconnect() {
        Map<String, List<String>> c = this.request.queryString();
        FluentStringsMap f = new FluentStringsMap();
        f.putAll(c);
        try {
            this.options.runtime().executeRequest(this.requestBuilder.setQueryParameters(f).build(), (AsyncHandler)this);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.STREAMING;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.status = Socket.STATUS.CLOSE;
        TransportsUtil.invokeFunction(Event.CLOSE, this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
        if (this.underlyingFuture != null) {
            this.underlyingFuture.cancel(false);
        }
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }

    @Override
    public void error(Throwable t) {
        this.logger.warn("", t);
        TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver);
    }

    @Override
    public void future(ListenableFuture f) {
        this.underlyingFuture = f;
    }

    @Override
    public void connectedFuture(Future f) {
        this.connectdFuture = f;
    }

    protected static final boolean whiteSpace(byte[] b) {
        int i = b.length;
        while (i-- > 0 && (b[i] == 10 || b[i] == 32)) {
        }
        return i == -1;
    }
}

