/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.OptionsBuilder;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultOptionsBuilder;
import org.atmosphere.wasync.impl.DefaultSocket;

public class ClientUtil {
    private static final String WASYNC_USER_AGENT = "wAsync/1.0";

    public static final AsyncHttpClient createDefaultAsyncHttpClient(Options o) {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        int t = o.requestTimeoutInSeconds();
        b.setFollowRedirects(true).setRequestTimeoutInMs(t == -1 ? t : t * 1000).setUserAgent(WASYNC_USER_AGENT);
        AsyncHttpClientConfig config = b.build();
        return new AsyncHttpClient(config);
    }

    public static Socket create(Options options) {
        AsyncHttpClient asyncHttpClient = options.runtime();
        if (asyncHttpClient == null || asyncHttpClient.isClosed()) {
            asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(options);
            options.runtime(asyncHttpClient);
        }
        return ClientUtil.getSocket(options);
    }

    public static final Socket getSocket(Options options) {
        return new DefaultSocket(options);
    }

    public static Socket create() {
        AsyncHttpClient asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(((OptionsBuilder)new DefaultOptionsBuilder().reconnect(true)).build());
        return ClientUtil.getSocket(((OptionsBuilder)new DefaultOptionsBuilder().runtime(asyncHttpClient, false)).build());
    }
}

