/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.decoder.TrackMessageSizeDecoder;
import org.atmosphere.wasync.impl.DefaultRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereRequest
extends DefaultRequest<AtmosphereRequestBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereRequest.class);

    protected AtmosphereRequest(AtmosphereRequestBuilder builder) {
        super(builder);
    }

    public CACHE getCacheType() {
        return ((AtmosphereRequestBuilder)this.builder).getCacheType();
    }

    public boolean isTrackMessageLength() {
        return ((AtmosphereRequestBuilder)this.builder).isTrackeMessageLength();
    }

    public String getTrackMessageLengthDelimiter() {
        return ((AtmosphereRequestBuilder)this.builder).getTrackMessageLengthDelimiter();
    }

    public static class AtmosphereRequestBuilder
    extends RequestBuilder<AtmosphereRequestBuilder> {
        private CACHE cacheType = CACHE.NO_BROADCAST_CACHE;
        private boolean trackMessageLength = false;
        private String trackMessageLengthDelimiter = "|";

        public AtmosphereRequestBuilder() {
            super(AtmosphereRequestBuilder.class);
            ArrayList<String> l = new ArrayList<String>();
            l.add("1.0");
            this.queryString.put("X-Atmosphere-Framework", l);
            l = new ArrayList();
            l.add("0");
            this.queryString.put("X-Atmosphere-tracking-id", l);
            l = new ArrayList();
            l.add("0");
            this.queryString.put("X-Cache-Date", l);
            l = new ArrayList();
            l.add("true");
            this.queryString.put("X-atmo-protocol", l);
        }

        private CACHE getCacheType() {
            return this.cacheType;
        }

        @Override
        public AtmosphereRequestBuilder transport(Request.TRANSPORT t) {
            if (this.queryString.get("X-Atmosphere-Transport") == null) {
                ArrayList<String> l = new ArrayList<String>();
                if (t.equals((Object)Request.TRANSPORT.LONG_POLLING)) {
                    l.add("long-polling");
                } else {
                    l.add(t.name());
                }
                this.queryString.put("X-Atmosphere-Transport", l);
            }
            this.transports.add(t);
            return (AtmosphereRequestBuilder)this.derived.cast(this);
        }

        public AtmosphereRequestBuilder cache(CACHE c) {
            this.cacheType = c;
            return this;
        }

        public AtmosphereRequestBuilder trackMessageLength(boolean trackMessageLength) {
            this.trackMessageLength = trackMessageLength;
            return this;
        }

        public AtmosphereRequestBuilder trackMessageLengthDelimiter(String trackMessageLengthDelimiter) {
            this.trackMessageLengthDelimiter = trackMessageLengthDelimiter;
            return this;
        }

        private boolean isTrackeMessageLength() {
            return this.trackMessageLength;
        }

        private String getTrackMessageLengthDelimiter() {
            return this.trackMessageLengthDelimiter;
        }

        @Override
        public AtmosphereRequest build() {
            if (this.trackMessageLength) {
                this.decoders().add(0, new TrackMessageSizeDecoder());
            }
            this.decoders().add(0, new Decoder<String, String>(){
                private AtomicBoolean protocolReceived = new AtomicBoolean();

                @Override
                public String decode(Event e, String s) {
                    if (e.equals((Object)Event.MESSAGE) && !this.protocolReceived.getAndSet(true)) {
                        try {
                            String[] proto = s.trim().split("\\|");
                            ArrayList<String> l = new ArrayList<String>();
                            l.add(proto[0]);
                            AtmosphereRequestBuilder.this.queryString.put("X-Atmosphere-tracking-id", l);
                            l = new ArrayList();
                            l.add(proto[1]);
                            AtmosphereRequestBuilder.this.queryString.put("X-Cache-Date", l);
                            s = null;
                        }
                        catch (Exception ex) {
                            logger.warn("Unable to decode the protocol {}", (Object)s);
                            logger.warn("", (Object)e);
                        }
                    }
                    return s;
                }
            });
            return new AtmosphereRequest(this);
        }
    }

    public static enum CACHE {
        HEADER_BROADCAST_CACHE,
        UUID_BROADCASTER_CACHE,
        SESSION_BROADCAST_CACHE,
        NO_BROADCAST_CACHE;

    }
}

