/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.ReplayDecoder;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.util.TypeResolver;

public class TransportsUtil {
    static void invokeFunction(List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        TransportsUtil.invokeFunction(Transport.EVENT_TYPE.MESSAGE, decoders, functions, implementedType, instanceType, functionName, resolver);
    }

    static void invokeFunction(Transport.EVENT_TYPE e, List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        String originalMessage = instanceType == null ? "" : instanceType.toString();
        for (FunctionWrapper wrapper : functions) {
            Function<?> f = wrapper.function();
            Class<?>[] typeArguments = TypeResolver.resolveArguments(f.getClass(), Function.class);
            if (typeArguments.length > 0 && instanceType != null && (instanceType = TransportsUtil.matchDecoder(e, instanceType, decoders)) != null) {
                implementedType = instanceType.getClass();
            }
            if (typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(implementedType) || !resolver.resolve(originalMessage, functionName, wrapper)) continue;
            f.on(instanceType);
        }
    }

    static Object matchDecoder(Transport.EVENT_TYPE e, Object instanceType, List<Decoder<? extends Object, ?>> decoders) {
        for (Decoder<Object, ?> d : decoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(d.getClass(), Decoder.class);
            if (instanceType == null || typeArguments.length <= 0 || !typeArguments[0].equals(instanceType.getClass())) continue;
            boolean replay = ReplayDecoder.class.isAssignableFrom(d.getClass());
            instanceType = d.decode(e, instanceType);
            if (!replay) continue;
            List l = (List)List.class.cast(instanceType);
            ArrayList nd = new ArrayList();
            boolean add = false;
            for (Decoder<Object, ?> d2 : decoders) {
                if (d2.equals(d)) {
                    add = true;
                    continue;
                }
                if (!add) continue;
                nd.add(d2);
            }
            Iterator<Decoder<Object, Object>> i$ = l.iterator();
            if (!i$.hasNext()) continue;
            Decoder<Object, Object> m = i$.next();
            return TransportsUtil.matchDecoder(e, m, nd);
        }
        return instanceType;
    }
}

