/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransport<T>
implements AsyncHandler<String>,
Transport {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(StreamTransport.class);
    protected Future f;
    protected final List<FunctionWrapper> functions;
    private final List<Decoder<? extends Object, ?>> decoders;
    protected String charSet = "UTF-8";
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;
    private final Request request;

    public StreamTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Transport.EVENT_TYPE e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
        this.request = request;
    }

    @Override
    public Transport future(Future f) {
        this.f = f;
        return this;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public void onThrowable(Throwable t) {
        TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Function.MESSAGE.error.name(), this.resolver);
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
        if (!m.isEmpty()) {
            TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Function.MESSAGE.message.name(), this.resolver);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Map.class, headers.getHeaders(), Function.MESSAGE.headers.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.f.done();
        TransportsUtil.invokeFunction(Transport.EVENT_TYPE.OPEN, this.decoders, this.functions, String.class, Function.MESSAGE.open.name(), Function.MESSAGE.open.name(), this.resolver);
        TransportsUtil.invokeFunction(Transport.EVENT_TYPE.MESSAGE, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Function.MESSAGE.status.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public String onCompleted() throws Exception {
        if (this.options.reconnect()) {
            ScheduledExecutorService e = this.options.runtime().getConfig().reaper();
            e.schedule(new Runnable(){

                @Override
                public void run() {
                    Map<String, List<String>> c = StreamTransport.this.request.queryString();
                    FluentStringsMap f = new FluentStringsMap();
                    f.putAll(c);
                    try {
                        StreamTransport.this.options.runtime().executeRequest(StreamTransport.this.requestBuilder.setQueryParameters(f).build(), (AsyncHandler)StreamTransport.this);
                    }
                    catch (IOException e) {
                        StreamTransport.this.logger.error("", (Throwable)e);
                    }
                }
            }, (long)this.options.reconnectInSeconds(), TimeUnit.SECONDS);
        }
        return "";
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.STREAMING;
    }

    @Override
    public void close() {
        TransportsUtil.invokeFunction(this.decoders, this.functions, String.class, Function.MESSAGE.close.name(), Function.MESSAGE.close.name(), this.resolver);
    }
}

