/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultSocket;

public class DefaultFuture
implements Future {
    private final Socket socket;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean done = new AtomicBoolean(false);

    public DefaultFuture(Socket socket) {
        this.socket = socket;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public Future done() {
        this.done.set(true);
        this.latch.countDown();
        return this;
    }

    @Override
    public Socket get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.socket;
    }

    @Override
    public Socket get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(timeout, unit);
        return this.socket;
    }

    protected Socket socket() {
        return this.socket;
    }

    @Override
    public Future fire(Object data) throws IOException {
        ((DefaultSocket)this.socket).internalSocket().write(((DefaultSocket)this.socket).request(), data);
        return new DefaultFuture(this.socket);
    }
}

