/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.inject.InjectableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringAtmosphereObjectFactory
extends InjectableObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringAtmosphereObjectFactory.class);
    private final ApplicationContext applicationContext;

    public SpringAtmosphereObjectFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void configure(AtmosphereConfig config) {
        super.configure(config);
    }

    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
        String[] beanNames = this.applicationContext.getBeanNamesForType(defaultType);
        if (beanNames.length > 0) {
            Object bean = this.applicationContext.getBean(defaultType);
            logger.trace("Found Spring bean for {}", (Object)defaultType.getName());
            this.inject(bean);
            return (U)bean;
        }
        try {
            AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
            Object instance = beanFactory.createBean(defaultType);
            logger.trace("Created and autowired Spring bean for {}", (Object)defaultType.getName());
            this.inject(instance);
            return (U)instance;
        }
        catch (Exception e) {
            logger.trace("Spring could not create {}; falling back to InjectableObjectFactory", (Object)defaultType.getName());
            return (U)super.newClassInstance(classType, defaultType);
        }
    }

    public String toString() {
        return "SpringAtmosphereObjectFactory";
    }
}

