/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.socketio.SocketIOException;
import org.atmosphere.socketio.SocketIOPacket;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.SocketIOSessionFactory;
import org.atmosphere.socketio.SocketIOWebSocketSessionWrapper;
import org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler;
import org.atmosphere.socketio.cpr.SocketIOWebSocketEventListener;
import org.atmosphere.socketio.transport.AbstractTransport;
import org.atmosphere.socketio.transport.DisconnectReason;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends AbstractTransport {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    public static final String TRANSPORT_NAME = "websocket";

    @Override
    public String getName() {
        return TRANSPORT_NAME;
    }

    @Override
    public Action handle(AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, SocketIOSessionFactory sessionFactory) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        Object obj = request.getAttribute(SESSION_KEY);
        SocketIOSession session = null;
        String sessionId = null;
        if (obj != null) {
            session = (SocketIOSession)obj;
        } else {
            sessionId = this.extractSessionId(request);
            if (sessionId != null && sessionId.length() > 0) {
                session = sessionFactory.getSession(sessionId);
            }
        }
        boolean isDisconnectRequest = this.isDisconnectRequest(request);
        if (!isDisconnectRequest) {
            if ("GET".equals(request.getMethod()) && "WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
                session = sessionFactory.getSession(sessionId);
                request.setAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid", (Object)session.getSessionId());
                request.setAttribute(SocketIOAtmosphereHandler.SOCKETIO_SESSION_ID, (Object)session.getSessionId());
                SocketIOWebSocketEventListener socketioEventListener = new SocketIOWebSocketEventListener();
                resource.addEventListener((AtmosphereResourceEventListener)socketioEventListener);
                SocketIOWebSocketSessionWrapperImpl sessionWrapper = new SocketIOWebSocketSessionWrapperImpl(session, socketioEventListener);
                socketioEventListener.setSessionWrapper(sessionWrapper);
                request.setAttribute("SocketIOSessionOutbound", (Object)sessionWrapper);
                resource.suspend(-1L);
            }
        } else {
            session = sessionFactory.getSession(sessionId);
            session.getTransportHandler().disconnect();
        }
        return Action.CANCELLED;
    }

    public class SocketIOWebSocketSessionWrapperImpl
    implements SocketIOWebSocketSessionWrapper {
        public final SocketIOSession session;
        public final SocketIOWebSocketEventListener socketioEventListener;
        public boolean initiated = false;
        public WebSocket webSocket;

        SocketIOWebSocketSessionWrapperImpl(SocketIOSession session, SocketIOWebSocketEventListener socketioEventListener) {
            this.session = session;
            this.socketioEventListener = socketioEventListener;
            this.socketioEventListener.setSessionWrapper(this);
        }

        @Override
        public void onDisconnect() {
            logger.trace("calling from " + this.getClass().getName() + " : onDisconnect");
            this.session.onShutdown();
        }

        @Override
        public void onMessage(byte frame, String message) {
            logger.trace("calling from " + this.getClass().getName() + " : onMessage");
            throw new RuntimeException();
        }

        @Override
        public void onMessage(byte frame, byte[] data, int offset, int length) {
            logger.trace("calling from " + this.getClass().getName() + " : onMessage frame, data, offest, length");
            try {
                this.onMessage(frame, new String(data, offset, length, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        @Override
        public void disconnect() {
            logger.trace("calling from " + this.getClass().getName() + " : disconnect");
            this.session.onDisconnect(DisconnectReason.DISCONNECT);
            this.webSocket.close();
        }

        @Override
        public void close() {
            logger.trace("calling from " + this.getClass().getName() + " : close");
            this.session.startClose();
        }

        @Override
        public void sendMessage(SocketIOPacket packet) throws SocketIOException {
            if (packet != null) {
                this.sendMessage(packet.toString());
            }
        }

        @Override
        public void sendMessage(List<SocketIOPacketImpl> messages) throws SocketIOException {
            if (messages != null) {
                block3: for (SocketIOPacketImpl msg : messages) {
                    switch (msg.getFrameType()) {
                        case MESSAGE: 
                        case JSON: 
                        case EVENT: 
                        case ACK: 
                        case ERROR: {
                            msg.setPadding(messages.size() > 1);
                            this.sendMessage(msg.toString());
                            continue block3;
                        }
                    }
                    logger.error("Unknown SocketIOEvent msg = " + msg);
                }
            }
        }

        @Override
        public void sendMessage(String message) throws SocketIOException {
            logger.trace("calling from " + this.getClass().getName() + " : sendMessage(string) = " + message);
            if (this.webSocket != null) {
                try {
                    this.webSocket.write(message);
                    logger.trace("WRITE SUCCESS : calling from " + this.getClass().getName() + " : sendMessage(string) = " + message);
                }
                catch (IOException e) {
                    throw new SocketIOException(e);
                }
            } else {
                logger.warn("WebSOCKET NULL");
            }
        }

        @Override
        public Action handle(AtmosphereRequest request, AtmosphereResponse response, SocketIOSession session) throws IOException {
            logger.trace("calling from " + this.getClass().getName() + " : handle");
            response.sendError(400, "Unexpected request on upgraded WebSocket connection");
            return Action.CONTINUE;
        }

        @Override
        public void abort() {
            logger.trace("calling from " + this.getClass().getName() + " : abort");
            this.webSocket.close();
            this.webSocket = null;
            this.session.onShutdown();
        }

        @Override
        public SocketIOSession getSession() {
            return this.session;
        }

        @Override
        public boolean isInitiated() {
            return this.initiated;
        }

        @Override
        public WebSocket webSocket() {
            return this.webSocket;
        }

        @Override
        public void setWebSocket(WebSocket websocket) {
            this.webSocket = websocket;
        }

        @Override
        public void initiated(boolean initiated) {
            this.initiated = initiated;
        }

        @Override
        public String getSessionId() {
            return this.session.getSessionId();
        }
    }
}

