/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.atmosphere.config.ApplicationConfiguration;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.config.AtmosphereHandlerProperty;
import org.atmosphere.config.FrameworkConfiguration;
import org.atmosphere.cpr.AtmosphereConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtmosphereConfigReader {
    private static final AtmosphereConfigReader instance = new AtmosphereConfigReader();
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereConfigReader.class);

    private AtmosphereConfigReader() {
    }

    public AtmosphereConfig parse(AtmosphereConfig config, String filename) throws FileNotFoundException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return this.parse(config, factory.newDocumentBuilder().parse(filename));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AtmosphereConfig parse(AtmosphereConfig config, InputStream stream) throws FileNotFoundException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return this.parse(config, factory.newDocumentBuilder().parse(stream));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private AtmosphereConfig parse(AtmosphereConfig config, Document document) {
        Element element = document.getDocumentElement();
        NodeList atmosphereHandlers = element.getElementsByTagName("atmosphere-handler");
        for (int i = 0; i < atmosphereHandlers.getLength(); ++i) {
            AtmosphereHandlerConfig atmoHandler = new AtmosphereHandlerConfig();
            Node root = atmosphereHandlers.item(i);
            block31: for (int j = 0; j < root.getAttributes().getLength(); ++j) {
                Node attribute = root.getAttributes().item(j);
                switch (attribute.getNodeName()) {
                    case "support-session": {
                        atmoHandler.setSupportSession(attribute.getNodeValue());
                        continue block31;
                    }
                    case "context-root": {
                        atmoHandler.setContextRoot(attribute.getNodeValue());
                        continue block31;
                    }
                    case "class-name": {
                        atmoHandler.setClassName(attribute.getNodeValue());
                        continue block31;
                    }
                    case "broadcaster": {
                        atmoHandler.setBroadcaster(attribute.getNodeValue());
                        continue block31;
                    }
                    case "broadcasterCache": {
                        atmoHandler.setBroadcasterCache(attribute.getNodeValue());
                        continue block31;
                    }
                    case "broadcastFilterClasses": {
                        String[] values;
                        for (String value : values = attribute.getNodeValue().split(",")) {
                            atmoHandler.getBroadcastFilterClasses().add(value);
                        }
                        continue block31;
                    }
                    case "comet-support": {
                        atmoHandler.setAsyncSupport(attribute.getNodeValue());
                        continue block31;
                    }
                    case "interceptorClasses": {
                        String[] values;
                        for (String value : values = attribute.getNodeValue().split(",")) {
                            atmoHandler.getAtmosphereInterceptorClasses().add(value);
                        }
                        continue block31;
                    }
                }
            }
            NodeList list = root.getChildNodes();
            block34: for (int j = 0; j < list.getLength(); ++j) {
                Node n = list.item(j);
                switch (n.getNodeName()) {
                    case "property": {
                        String param = n.getAttributes().getNamedItem("name").getNodeValue();
                        String value = n.getAttributes().getNamedItem("value").getNodeValue();
                        atmoHandler.getProperties().add(new AtmosphereHandlerProperty(param, value));
                        continue block34;
                    }
                    case "applicationConfig": {
                        Node n2;
                        int k;
                        String param = null;
                        String value = null;
                        for (k = 0; k < n.getChildNodes().getLength(); ++k) {
                            n2 = n.getChildNodes().item(k);
                            if (n2.getNodeName().equals("param-name")) {
                                param = n2.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (!n2.getNodeName().equals("param-value")) continue;
                            value = n2.getFirstChild().getNodeValue();
                        }
                        if (param == null) continue block34;
                        atmoHandler.getApplicationConfig().add(new ApplicationConfiguration(param, value));
                        continue block34;
                    }
                    case "frameworkConfig": {
                        Node n2;
                        int k;
                        String param = null;
                        String value = null;
                        for (k = 0; k < n.getChildNodes().getLength(); ++k) {
                            n2 = n.getChildNodes().item(k);
                            if (n2.getNodeName().equals("param-name")) {
                                param = n2.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (!n2.getNodeName().equals("param-value")) continue;
                            value = n2.getFirstChild().getNodeValue();
                        }
                        if (param == null) continue block34;
                        atmoHandler.getFrameworkConfig().add(new FrameworkConfiguration(param, value));
                        continue block34;
                    }
                }
            }
            config.getAtmosphereHandlerConfig().add(atmoHandler);
        }
        return config;
    }

    public static AtmosphereConfigReader getInstance() {
        return instance;
    }
}

