/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.room.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.atmosphere.room.RoomMember;
import org.atmosphere.room.protocol.RoomProtocolMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public final class RoomProtocolCodec {
    private RoomProtocolCodec() {
    }

    public static RoomProtocolMessage decode(String json) {
        JSONObject obj = new JSONObject(json);
        String type = obj.getString("type");
        String room = obj.getString("room");
        return switch (type) {
            case "join" -> new RoomProtocolMessage.Join(room, obj.optString("memberId", null), RoomProtocolCodec.toMap(obj.optJSONObject("metadata")));
            case "leave" -> new RoomProtocolMessage.Leave(room);
            case "broadcast" -> new RoomProtocolMessage.Broadcast(room, obj.get("data"));
            case "direct" -> new RoomProtocolMessage.Direct(room, obj.getString("targetId"), obj.get("data"));
            default -> throw new IllegalArgumentException("Unknown room protocol type: " + type);
        };
    }

    public static String encodeJoinAck(String room, Collection<RoomMember> members) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"join_ack");
        obj.put("room", (Object)room);
        JSONArray arr = new JSONArray();
        for (RoomMember m : members) {
            JSONObject memberObj = new JSONObject();
            memberObj.put("id", (Object)m.id());
            memberObj.put("metadata", (Object)new JSONObject(m.metadata()));
            arr.put((Object)memberObj);
        }
        obj.put("members", (Object)arr);
        return obj.toString();
    }

    public static String encodePresence(String room, String action, RoomMember member) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"presence");
        obj.put("room", (Object)room);
        obj.put("action", (Object)action);
        if (member != null) {
            obj.put("memberId", (Object)member.id());
            obj.put("metadata", (Object)new JSONObject(member.metadata()));
        }
        return obj.toString();
    }

    public static String encodeMessage(String room, String fromMemberId, Object data) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"message");
        obj.put("room", (Object)room);
        if (fromMemberId != null) {
            obj.put("from", (Object)fromMemberId);
        }
        obj.put("data", data);
        return obj.toString();
    }

    public static String encodeError(String room, String message) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"error");
        obj.put("room", (Object)room);
        obj.put("data", (Object)message);
        return obj.toString();
    }

    private static Map<String, Object> toMap(JSONObject json) {
        if (json == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : json.keySet()) {
            map.put(key, json.get(key));
        }
        return map;
    }
}

