/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.CompletionAware;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.ChunkConcatReaderPool;
import org.atmosphere.util.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRestInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRestInterceptor.class);
    public static final String X_REQUEST_KEY = "X-Request-Key";
    protected static final String REQUEST_DISPATCHED = "request.dispatched";
    protected static final String REQUEST_ID = "request.id";
    private static final String HEARTBEAT_BROADCASTER_NAME = "/simple-rest.heartbeat";
    private static final String HEARTBEAT_SCHEDULED = "heatbeat.scheduled";
    private static final String HEARTBEAT_TEMPLATE = "{\"heartbeat\": \"%s\", \"time\": %d}";
    private static final long DEFAULT_HEARTBEAT_INTERVAL = 60L;
    private final Map<String, AtmosphereResponse> suspendedResponses = new HashMap<String, AtmosphereResponse>();
    private final ChunkConcatReaderPool readerPool = new ChunkConcatReaderPool();
    private Broadcaster heartbeat;
    private boolean heartbeatScheduled;
    private final AsyncIOInterceptor interceptor = new Interceptor();

    @Override
    public void configure(AtmosphereConfig config) {
        super.configure(config);
        this.heartbeat = config.getBroadcasterFactory().lookup(DefaultBroadcaster.class, this.getHeartbeatBroadcasterName());
        if (this.heartbeat == null) {
            this.heartbeat = config.getBroadcasterFactory().get(DefaultBroadcaster.class, this.getHeartbeatBroadcasterName());
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        if (AtmosphereResource.TRANSPORT.WEBSOCKET != r.transport() && AtmosphereResource.TRANSPORT.SSE != r.transport() && AtmosphereResource.TRANSPORT.POLLING != r.transport()) {
            LOG.debug("Skipping for non websocket request");
            return Action.CONTINUE;
        }
        if (AtmosphereResource.TRANSPORT.POLLING == r.transport()) {
            String saruuid = (String)r.getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
            final AtmosphereResponse suspendedResponse = this.suspendedResponses.get(saruuid);
            LOG.debug("Attaching a proxy writer to suspended response");
            r.getResponse().asyncIOWriter(new AtmosphereInterceptorWriter(this){

                @Override
                public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
                    suspendedResponse.write(data);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                @Override
                public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
                    suspendedResponse.write(data);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                @Override
                public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
                    suspendedResponse.write(data, offset, length);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                @Override
                public void close(AtmosphereResponse response) {
                }
            });
            r.getResponse().destroyable(false);
            return Action.CONTINUE;
        }
        r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

            @Override
            public void onSuspend(AtmosphereResourceEvent event) {
                String srid = (String)event.getResource().getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                LOG.debug("Registrering suspended resource: {}", (Object)srid);
                SimpleRestInterceptor.this.suspendedResponses.put(srid, event.getResource().getResponse());
                AsyncIOWriter writer = event.getResource().getResponse().getAsyncIOWriter();
                if (writer == null) {
                    writer = new AtmosphereInterceptorWriter();
                    r.getResponse().asyncIOWriter(writer);
                }
                if (writer instanceof AtmosphereInterceptorWriter) {
                    AtmosphereInterceptorWriter aiw = (AtmosphereInterceptorWriter)writer;
                    aiw.interceptor(SimpleRestInterceptor.this.interceptor);
                }
            }

            @Override
            public void onDisconnect(AtmosphereResourceEvent event) {
                super.onDisconnect(event);
                String srid = (String)event.getResource().getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                LOG.debug("Unregistrering suspended resource: {}", (Object)srid);
                SimpleRestInterceptor.this.suspendedResponses.remove(srid);
            }
        });
        AtmosphereRequest request = r.getRequest();
        if (request.getAttribute(REQUEST_DISPATCHED) == null) {
            try {
                String body = IOUtils.readEntirelyAsString(r).toString();
                LOG.debug("Request message: '{}'", (Object)body);
                if (body.length() == 0) {
                    if ((AtmosphereResource.TRANSPORT.WEBSOCKET == r.transport() || AtmosphereResource.TRANSPORT.SSE == r.transport()) && request.getAttribute(HEARTBEAT_SCHEDULED) == null) {
                        r.suspend();
                        this.scheduleHeartbeat(r);
                        request.setAttribute(HEARTBEAT_SCHEDULED, "true");
                        return Action.SUSPEND;
                    }
                    return Action.CANCELLED;
                }
                AtmosphereRequest ar = this.createAtmosphereRequest(request, body);
                if (ar == null) {
                    return Action.CANCELLED;
                }
                AtmosphereResponse response = r.getResponse();
                ar.localAttributes().put(REQUEST_DISPATCHED, "true");
                request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
                response.request(ar);
                this.attachWriter(r);
                Action action = r.getAtmosphereConfig().framework().doCometSupport(ar, response);
                if (action.type() == Action.TYPE.SUSPEND) {
                    ar.destroyable(false);
                    response.destroyable(false);
                }
                return Action.CANCELLED;
            }
            catch (ServletException | IOException e) {
                LOG.error("Failed to process", e);
            }
        }
        return Action.CONTINUE;
    }

    protected String getHeartbeatBroadcasterName() {
        return HEARTBEAT_BROADCASTER_NAME;
    }

    protected String getHeartbeatTemplate() {
        return HEARTBEAT_TEMPLATE;
    }

    protected Object[] getHeartbeatTemplateArguments() {
        return new Object[]{UUID.randomUUID().toString(), System.currentTimeMillis()};
    }

    protected AtmosphereRequest createAtmosphereRequest(AtmosphereRequest request, String body) throws IOException {
        int qpos;
        String uuid = request.getHeader("X-Atmosphere-tracking-id");
        StringReader msgreader = new StringReader(body);
        JSONObject jsonpart = SimpleRestInterceptor.parseJsonPart(msgreader);
        String id = SimpleRestInterceptor.getString(jsonpart, "id");
        if (id != null) {
            request.localAttributes().put(REQUEST_ID, id);
        }
        boolean skip = false;
        boolean continued = SimpleRestInterceptor.getBoolean(jsonpart, "continue");
        Reader reader = this.readerPool.getReader(id, false);
        if (reader != null) {
            skip = true;
        } else if (continued) {
            reader = this.readerPool.getReader(id, true);
        }
        if (skip) {
            this.readerPool.addChunk(id, msgreader, continued);
            return null;
        }
        String method = SimpleRestInterceptor.getString(jsonpart, "method");
        String path = SimpleRestInterceptor.getString(jsonpart, "path");
        String type = SimpleRestInterceptor.getString(jsonpart, "type");
        String accept = SimpleRestInterceptor.getString(jsonpart, "accept");
        AtmosphereRequestImpl.Builder b = new AtmosphereRequestImpl.Builder();
        b.method(method != null ? method : "GET").pathInfo(path != null ? path : "/");
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.put(X_REQUEST_KEY, String.format("%s#%s", uuid, id));
        if (accept != null) {
            headers.put("Accept", accept);
        }
        if (type != null) {
            b.contentType(type);
        }
        b.headers(headers);
        int n = qpos = path != null ? path.indexOf(63) : 0;
        if (qpos > 0) {
            b.queryString(path.substring(qpos + 1));
            path = path.substring(0, qpos);
        }
        if (reader != null) {
            b.reader(reader);
            this.readerPool.addChunk(id, msgreader, true);
        } else {
            b.reader(msgreader);
        }
        String requestURL = String.valueOf(request.getRequestURL()) + (path != null ? path.substring(request.getRequestURI().length()) : null);
        b.requestURI(path).requestURL(requestURL).request(request);
        return b.build();
    }

    protected byte[] createResponse(AtmosphereResponse response, byte[] payload) {
        AtmosphereRequest request;
        String id;
        if (LOG.isDebugEnabled()) {
            LOG.debug("createResponse for payload {}", (Object)new String(payload));
        }
        if ((id = (String)(request = response.request()).getAttribute(REQUEST_ID)) == null) {
            return payload;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JSONObject jsonpart = new JSONObject();
            jsonpart.put("id", (Object)id);
            jsonpart.put("code", response.getStatus());
            String ct = response.getContentType();
            if (ct != null) {
                jsonpart.put("type", (Object)ct);
            }
            if (!SimpleRestInterceptor.isLastResponse(request, response)) {
                jsonpart.put("continue", true);
            }
            baos.write(jsonpart.toString().getBytes(StandardCharsets.UTF_8));
            baos.write(payload);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    private void scheduleHeartbeat(AtmosphereResource r) {
        this.heartbeat.addAtmosphereResource(r);
        if (!this.heartbeatScheduled) {
            this.heartbeat.scheduleFixedBroadcast(String.format(this.getHeartbeatTemplate(), this.getHeartbeatTemplateArguments()), 60L, 60L, TimeUnit.SECONDS);
            this.heartbeatScheduled = true;
        }
    }

    protected static boolean isLastResponse(AtmosphereRequest request, AtmosphereResponse response) {
        CompletionAware ca;
        return response instanceof CompletionAware && (ca = (CompletionAware)((Object)response)).completed() || Boolean.TRUE != request.getAttribute("org.atmosphere.cpr.ResponseCompletionAware");
    }

    private void attachWriter(AtmosphereResource r) {
        AtmosphereResponse res = r.getResponse();
        AsyncIOWriter writer = res.getAsyncIOWriter();
        if (writer instanceof AtmosphereInterceptorWriter) {
            AtmosphereInterceptorWriter aiw = (AtmosphereInterceptorWriter)writer;
            aiw.interceptor(this.interceptor, 0);
        }
    }

    protected static boolean isJSONObject(byte[] b) {
        return b.length > 0 && (b[0] == 91 || b[0] == 123);
    }

    protected static byte[] quote(byte[] b) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(34);
        for (byte c : b) {
            if (c == 34) {
                baos.write(92);
            }
            baos.write(c);
        }
        baos.write(34);
        return baos.toByteArray();
    }

    protected static JSONObject parseJsonPart(Reader reader) throws JSONException {
        return (JSONObject)new JSONTokener(reader).nextValue();
    }

    protected static String getString(JSONObject obj, String key) {
        try {
            return obj.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected static boolean getBoolean(JSONObject obj, String key) {
        try {
            return obj.getBoolean(key);
        }
        catch (JSONException e) {
            return false;
        }
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        @Override
        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            return SimpleRestInterceptor.this.createResponse(response, responseDraft);
        }
    }
}

