/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.MDC;

public class MDCInterceptor
extends AtmosphereInterceptorAdapter {
    public static final String MDC_UUID = "atmosphere.uuid";
    public static final String MDC_TRANSPORT = "atmosphere.transport";
    public static final String MDC_BROADCASTER = "atmosphere.broadcaster";

    @Override
    public Action inspect(AtmosphereResource r) {
        super.inspect(r);
        MDC.put((String)MDC_UUID, (String)r.uuid());
        if (r.transport() != null) {
            MDC.put((String)MDC_TRANSPORT, (String)r.transport().name());
        }
        if (r.getBroadcaster() != null) {
            MDC.put((String)MDC_BROADCASTER, (String)r.getBroadcaster().getID());
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
        MDC.remove((String)MDC_UUID);
        MDC.remove((String)MDC_TRANSPORT);
        MDC.remove((String)MDC_BROADCASTER);
    }

    @Override
    public String toString() {
        return "MDCInterceptor{}";
    }
}

