/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.interceptor.AndroidAtmosphereInterceptor;
import org.atmosphere.interceptor.CacheHeadersInterceptor;
import org.atmosphere.interceptor.CorsInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.interceptor.IdleResourceInterceptor;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.interceptor.JavaScriptProtocol;
import org.atmosphere.interceptor.OnDisconnectInterceptor;
import org.atmosphere.interceptor.PaddingAtmosphereInterceptor;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.interceptor.WebSocketMessageSuspendInterceptor;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(InterceptorRegistry.class);
    public static final List<Class<? extends AtmosphereInterceptor>> DEFAULT_ATMOSPHERE_INTERCEPTORS = List.of(CorsInterceptor.class, CacheHeadersInterceptor.class, PaddingAtmosphereInterceptor.class, AndroidAtmosphereInterceptor.class, HeartbeatInterceptor.class, SSEAtmosphereInterceptor.class, JavaScriptProtocol.class, WebSocketMessageSuspendInterceptor.class, OnDisconnectInterceptor.class, IdleResourceInterceptor.class);
    private final AtmosphereConfig config;
    private final LinkedList<AtmosphereInterceptor> interceptors = new LinkedList();
    private final List<String> excludedInterceptors = new ArrayList<String>();
    private Supplier<Map<String, AtmosphereHandlerWrapper>> handlersSupplier;

    public InterceptorRegistry(AtmosphereConfig config) {
        this.config = config;
    }

    void setHandlersSupplier(Supplier<Map<String, AtmosphereHandlerWrapper>> handlersSupplier) {
        this.handlersSupplier = handlersSupplier;
    }

    void parseInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereInterceptor.disable");
        if (s != null) {
            this.excludedInterceptors.addAll(Arrays.asList(s.trim().replace(" ", "").split(",")));
        }
    }

    public boolean addInterceptor(AtmosphereInterceptor c, boolean initialized) {
        if (!this.checkDuplicate(c)) {
            this.interceptors.add(c);
            if (initialized) {
                this.addInterceptorToAllWrappers(c);
            }
            return true;
        }
        return false;
    }

    public LinkedList<AtmosphereInterceptor> interceptors() {
        return this.interceptors;
    }

    @Deprecated(since="4.0.0", forRemoval=false)
    public <T extends AtmosphereInterceptor> T interceptor(Class<T> c) {
        for (AtmosphereInterceptor i : this.interceptors) {
            if (!c.isInstance(i)) continue;
            return (T)((AtmosphereInterceptor)c.cast(i));
        }
        return null;
    }

    public <T extends AtmosphereInterceptor> Optional<T> findInterceptor(Class<T> c) {
        for (AtmosphereInterceptor i : this.interceptors) {
            if (!c.isInstance(i)) continue;
            return Optional.of((AtmosphereInterceptor)c.cast(i));
        }
        return Optional.empty();
    }

    public void excludeInterceptor(String interceptor) {
        this.excludedInterceptors.add(interceptor);
    }

    public List<String> excludedInterceptors() {
        return this.excludedInterceptors;
    }

    public Class<? extends AtmosphereInterceptor>[] defaultInterceptors() {
        return DEFAULT_ATMOSPHERE_INTERCEPTORS.toArray(new Class[DEFAULT_ATMOSPHERE_INTERCEPTORS.size()]);
    }

    public void configure(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereInterceptor");
        if (s != null) {
            String[] list;
            for (String a : list = s.split(",")) {
                try {
                    AtmosphereInterceptor ai = this.config.framework().newClassInstance(AtmosphereInterceptor.class, IOUtils.loadClass(this.config.framework().getClass(), a.trim()));
                    this.addInterceptor(ai, this.config.framework().isInit);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
        if (!Boolean.parseBoolean(s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereInterceptor.disableDefaults"))) {
            logger.info("Installing Default AtmosphereInterceptors");
            for (Class<? extends AtmosphereInterceptor> a : DEFAULT_ATMOSPHERE_INTERCEPTORS) {
                if (!this.excludedInterceptors.contains(a.getName())) {
                    AtmosphereInterceptor ai = this.newInterceptor(a);
                    if (ai == null) continue;
                    this.interceptors.add(ai);
                    continue;
                }
                logger.info("Dropping Interceptor {}", (Object)a.getName());
            }
            logger.info("Set {} to disable them.", (Object)"org.atmosphere.cpr.AtmosphereInterceptor.disableDefaults");
        }
        this.addDefaultOrAppInterceptors();
    }

    public AtmosphereInterceptor newInterceptor(Class<? extends AtmosphereInterceptor> a) {
        AtmosphereInterceptor ai = null;
        try {
            ai = this.config.framework().newClassInstance(AtmosphereInterceptor.class, IOUtils.loadClass(this.config.framework().getClass(), a.getName()));
            logger.info("\t{} : {}", (Object)a.getName(), (Object)ai);
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
        }
        return ai;
    }

    public void addDefaultOrAppInterceptors() {
        for (AtmosphereInterceptor c : this.interceptors) {
            this.addInterceptorToAllWrappers(c);
        }
    }

    public void addInterceptorToAllWrappers(AtmosphereInterceptor c) {
        InvokationOrder.PRIORITY pRIORITY;
        c.configure(this.config);
        if (c instanceof InvokationOrder) {
            InvokationOrder io = (InvokationOrder)((Object)c);
            pRIORITY = io.priority();
        } else {
            pRIORITY = InvokationOrder.AFTER_DEFAULT;
        }
        InvokationOrder.PRIORITY p = pRIORITY;
        logger.info("Installed AtmosphereInterceptor {} with priority {} ", (Object)c, (Object)p.name());
        if (this.handlersSupplier != null) {
            for (AtmosphereHandlerWrapper wrapper : this.handlersSupplier.get().values()) {
                this.addInterceptorToWrapper(wrapper, c);
            }
        }
    }

    public void addInterceptorToWrapper(AtmosphereHandlerWrapper wrapper, AtmosphereInterceptor c) {
        if (!this.checkDuplicate(wrapper.interceptors(), c.getClass())) {
            wrapper.interceptors().add(c);
            wrapper.interceptors().sort(new InterceptorComparator());
        }
    }

    public void addInterceptorToWrapper(AtmosphereHandlerWrapper wrapper, List<AtmosphereInterceptor> handlerInterceptors) {
        for (AtmosphereInterceptor c : this.interceptors) {
            this.addInterceptorToWrapper(wrapper, c);
        }
        for (AtmosphereInterceptor c : handlerInterceptors) {
            this.addInterceptorToWrapper(wrapper, c);
            c.configure(this.config);
        }
    }

    public void destroyInterceptors(Map<String, AtmosphereHandlerWrapper> handlers) {
        for (AtmosphereHandlerWrapper w : handlers.values()) {
            for (AtmosphereInterceptor i : w.interceptors()) {
                try {
                    i.destroy();
                }
                catch (Throwable ex) {
                    logger.warn("", ex);
                }
            }
        }
    }

    public void clear() {
        this.interceptors.clear();
        this.excludedInterceptors.clear();
    }

    private boolean checkDuplicate(AtmosphereInterceptor c) {
        return this.checkDuplicate(this.interceptors, c.getClass());
    }

    private boolean checkDuplicate(List<AtmosphereInterceptor> interceptorList, Class<? extends AtmosphereInterceptor> c) {
        for (AtmosphereInterceptor i : interceptorList) {
            if (!i.getClass().equals(c)) continue;
            return true;
        }
        return false;
    }

    static class InterceptorComparator
    implements Comparator<AtmosphereInterceptor> {
        InterceptorComparator() {
        }

        @Override
        public int compare(AtmosphereInterceptor i1, AtmosphereInterceptor i2) {
            InvokationOrder.PRIORITY p2;
            InvokationOrder.PRIORITY p1;
            if (i1 instanceof InvokationOrder) {
                InvokationOrder io1 = (InvokationOrder)((Object)i1);
                p1 = io1.priority();
            } else {
                p1 = InvokationOrder.PRIORITY.AFTER_DEFAULT;
            }
            if (i2 instanceof InvokationOrder) {
                InvokationOrder io2 = (InvokationOrder)((Object)i2);
                p2 = io2.priority();
            } else {
                p2 = InvokationOrder.PRIORITY.AFTER_DEFAULT;
            }
            int orderResult = 0;
            block0 : switch (p1) {
                case AFTER_DEFAULT: {
                    switch (p2) {
                        case BEFORE_DEFAULT: 
                        case FIRST_BEFORE_DEFAULT: {
                            orderResult = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case BEFORE_DEFAULT: {
                    switch (p2) {
                        case AFTER_DEFAULT: {
                            orderResult = -1;
                            break block0;
                        }
                        case FIRST_BEFORE_DEFAULT: {
                            orderResult = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case FIRST_BEFORE_DEFAULT: {
                    switch (p2) {
                        case BEFORE_DEFAULT: 
                        case AFTER_DEFAULT: {
                            orderResult = -1;
                            break block0;
                        }
                    }
                }
            }
            return orderResult;
        }
    }
}

