/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.lifecycle.BroadcasterLifecyclePolicyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcasterFactory
implements BroadcasterFactory {
    protected final ConcurrentLinkedQueue<BroadcasterListener> broadcasterListeners = new ConcurrentLinkedQueue();
    private static final Logger logger = LoggerFactory.getLogger(DefaultBroadcasterFactory.class);
    protected final ConcurrentHashMap<Object, Broadcaster> store = new ConcurrentHashMap();
    protected Class<? extends Broadcaster> clazz;
    protected BroadcasterLifeCyclePolicy policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
    protected Broadcaster.POLICY defaultPolicy = Broadcaster.POLICY.FIFO;
    protected int defaultPolicyInteger = -1;
    private final ReentrantLock lock = new ReentrantLock();
    protected AtmosphereConfig config;
    protected final BroadcasterListener lifeCycleListener = new BroadcasterLifecyclePolicyHandler();
    public static final URI legacyBroadcasterURI = URI.create("http://127.0.0.0");

    @Override
    public void configure(Class<? extends Broadcaster> clazz, String broadcasterLifeCyclePolicy, AtmosphereConfig c) {
        this.clazz = clazz;
        this.config = c;
        this.configure(broadcasterLifeCyclePolicy);
    }

    protected void configure(String broadcasterLifeCyclePolicy) {
        int maxIdleTime = 300000;
        String s = this.config.getInitParameter("org.atmosphere.cpr.maxBroadcasterLifeCyclePolicyIdleTime");
        if (s != null) {
            maxIdleTime = Integer.parseInt(s);
        }
        if ((s = this.config.getInitParameter("org.atmosphere.cpr.Broadcaster.POLICY")) != null) {
            Broadcaster.POLICY pOLICY = this.defaultPolicy = s.equalsIgnoreCase(Broadcaster.POLICY.REJECT.name()) ? Broadcaster.POLICY.REJECT : Broadcaster.POLICY.FIFO;
        }
        if ((s = this.config.getInitParameter("org.atmosphere.cpr.Broadcaster.POLICY.maximumSuspended")) != null) {
            this.defaultPolicyInteger = Integer.parseInt(s);
        }
        if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_EMPTY_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_EMPTY_DESTROY).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
        } else {
            logger.warn("Unsupported BroadcasterLifeCyclePolicy policy {}", (Object)broadcasterLifeCyclePolicy);
        }
        this.broadcasterListeners.add(this.lifeCycleListener);
    }

    @Override
    public Broadcaster get() {
        this.lock.lock();
        try {
            Broadcaster broadcaster = this.get(this.clazz.getSimpleName() + "-" + this.config.uuidProvider().generateUuid());
            return broadcaster;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Broadcaster get(Object id) {
        return this.get(this.clazz, id);
    }

    @Override
    public <T extends Broadcaster> T get(Class<T> c, Object id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (c == null) {
            throw new NullPointerException("Class is null");
        }
        return this.lookup(c, id, true, true);
    }

    protected <T extends Broadcaster> T createBroadcaster(Class<T> c, Object id) throws BroadcasterFactory.BroadcasterCreationException {
        try {
            Broadcaster b = (Broadcaster)this.config.framework().newClassInstance(c, c);
            b.initialize(id.toString(), legacyBroadcasterURI, this.config);
            b.setSuspendPolicy(this.defaultPolicyInteger, this.defaultPolicy);
            if (b.getBroadcasterConfig() == null) {
                b.setBroadcasterConfig(new BroadcasterConfig(this.config.framework().broadcasterFilters(), this.config, id.toString()).init());
            }
            b.setBroadcasterLifeCyclePolicy(this.policy);
            if (DefaultBroadcaster.class.isAssignableFrom(this.clazz)) {
                ((DefaultBroadcaster)b).start();
            }
            this.broadcasterListeners.forEach(b::addBroadcasterListener);
            logger.trace("Broadcaster {} was created {}", id, (Object)b);
            this.notifyOnPostCreate(b);
            return (T)b;
        }
        catch (Throwable t) {
            throw new BroadcasterFactory.BroadcasterCreationException(t);
        }
    }

    @Override
    public boolean add(Broadcaster b, Object id) {
        return this.store.put(id, b) == null;
    }

    @Override
    public boolean remove(Broadcaster b, Object id) {
        boolean removed = this.store.remove(id, b);
        if (removed && logger.isDebugEnabled()) {
            logger.debug("Removing Broadcaster {} factory size now {} ", id, (Object)this.store.size());
        }
        return removed;
    }

    @Override
    public <T extends Broadcaster> T lookup(Class<T> c, Object id) {
        return this.lookup(c, id, false);
    }

    @Override
    public <T extends Broadcaster> T lookup(Object id) {
        return (T)this.lookup(this.clazz, id, false);
    }

    @Override
    public <T extends Broadcaster> T lookup(Object id, boolean createIfNull) {
        return (T)this.lookup(this.clazz, id, createIfNull);
    }

    @Override
    public <T extends Broadcaster> T lookup(Class<T> c, Object id, boolean createIfNull) {
        return this.lookup(c, id, createIfNull, false);
    }

    public <T extends Broadcaster> T lookup(Class<T> c, Object id, boolean createIfNull, boolean unique) {
        logger.trace("About to create {}", id);
        Broadcaster b = this.store.get(id);
        if (b != null) {
            if (unique) {
                throw new IllegalStateException("Broadcaster already exists " + String.valueOf(id) + ". Use BroadcasterFactory.lookup instead");
            }
            if (b.isDestroyed()) {
                logger.trace("Removing destroyed Broadcaster {}", (Object)b.getID());
                this.store.remove(b.getID(), b);
                createIfNull = true;
            } else {
                createIfNull = false;
            }
        }
        if (createIfNull) {
            b = this.store.computeIfAbsent(id, new CreateBroacasterFunction(c));
        }
        if (b != null && !c.isInstance(b)) {
            String msg = "Invalid lookup class " + c.getName() + ". Cached class is: " + b.getClass().getName();
            logger.debug(msg);
            throw new IllegalStateException(msg);
        }
        return (T)b;
    }

    @Override
    public boolean remove(Object id) {
        return this.store.remove(id) != null;
    }

    @Override
    public Collection<Broadcaster> lookupAll() {
        return Collections.unmodifiableCollection(this.store.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.lock.lock();
        try {
            if (this.config == null) {
                return;
            }
            String s = this.config.getInitParameter("org.atmosphere.runtime.shared");
            if (s != null && s.equalsIgnoreCase("true")) {
                logger.warn("Factory shared, will not be destroyed. This can possibly cause memory leaks ifBroadcasters were created. Make sure you destroy them manually.");
                return;
            }
            Enumeration<Broadcaster> e = this.store.elements();
            while (e.hasMoreElements()) {
                try {
                    Broadcaster b = e.nextElement();
                    BroadcasterConfig bc = b.getBroadcasterConfig();
                    bc.forceDestroy();
                    b.destroy();
                }
                catch (Throwable t) {
                    logger.debug("Destroy", t);
                }
            }
            this.broadcasterListeners.clear();
            this.store.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyOnPostCreate(Broadcaster b) {
        for (BroadcasterListener l : this.broadcasterListeners) {
            try {
                l.onPostCreate(b);
            }
            catch (Exception ex) {
                logger.warn("onPostCreate", (Throwable)ex);
            }
        }
    }

    @Override
    public BroadcasterFactory addBroadcasterListener(BroadcasterListener l) {
        if (!this.broadcasterListeners.contains(l)) {
            this.broadcasterListeners.add(l);
        }
        for (Broadcaster b : this.store.values()) {
            b.addBroadcasterListener(l);
        }
        return this;
    }

    @Override
    public BroadcasterFactory removeBroadcasterListener(BroadcasterListener l) {
        this.broadcasterListeners.remove(l);
        for (Broadcaster b : this.store.values()) {
            b.removeBroadcasterListener(l);
        }
        return this;
    }

    @Override
    public Collection<BroadcasterListener> broadcasterListeners() {
        return this.broadcasterListeners;
    }

    private class CreateBroacasterFunction
    implements Function<Object, Broadcaster> {
        private Class<? extends Broadcaster> c;

        private CreateBroacasterFunction(Class<? extends Broadcaster> c) {
            this.c = c;
        }

        @Override
        public Broadcaster apply(Object id) {
            Broadcaster b = DefaultBroadcasterFactory.this.createBroadcaster(this.c, id);
            if (logger.isTraceEnabled()) {
                logger.trace("Added Broadcaster {} . Factory size: {}", id, (Object)DefaultBroadcasterFactory.this.store.size());
            }
            return b;
        }
    }
}

