/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.DefaultBroadcasterCache;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultAtmosphereResourceFactory;
import org.atmosphere.cpr.DefaultAtmosphereResourceSessionFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.DefaultMetaBroadcaster;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcasterSetup {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterSetup.class);
    private final List<String> broadcasterFilters = new ArrayList<String>();
    private final ConcurrentLinkedQueue<String> broadcasterTypes = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<BroadcasterCacheInspector> inspectors = new ConcurrentLinkedQueue();
    private final List<BroadcasterListener> broadcasterListeners = new CopyOnWriteArrayList<BroadcasterListener>();
    private final LinkedList<BroadcasterCacheListener> broadcasterCacheListeners = new LinkedList();
    private final List<BroadcasterConfig.FilterManipulator> filterManipulators = new ArrayList<BroadcasterConfig.FilterManipulator>();
    private final ReentrantLock resourceFactoryLock = new ReentrantLock();
    private final ReentrantLock sessionFactoryLock = new ReentrantLock();
    private String broadcasterClassName = DefaultBroadcaster.class.getName();
    private boolean broadcasterSpecified;
    private BroadcasterFactory broadcasterFactory;
    private String broadcasterFactoryClassName;
    private String broadcasterCacheClassName;
    private String broadcasterLifeCyclePolicy = "NEVER";
    private AtmosphereResourceFactory arFactory;
    private MetaBroadcaster metaBroadcaster;
    private AtmosphereResourceSessionFactory sessionFactory;
    private String defaultSerializerClassName;
    private Class<Serializer> defaultSerializerClass;
    private final AtmosphereConfig config;
    private Supplier<Map<String, AtmosphereHandlerWrapper>> handlersSupplier;

    List<String> broadcasterFilters() {
        return this.broadcasterFilters;
    }

    ConcurrentLinkedQueue<String> broadcasterTypes() {
        return this.broadcasterTypes;
    }

    ConcurrentLinkedQueue<BroadcasterCacheInspector> inspectors() {
        return this.inspectors;
    }

    List<BroadcasterListener> broadcasterListeners() {
        return this.broadcasterListeners;
    }

    LinkedList<BroadcasterCacheListener> broadcasterCacheListeners() {
        return this.broadcasterCacheListeners;
    }

    List<BroadcasterConfig.FilterManipulator> filterManipulators() {
        return this.filterManipulators;
    }

    String broadcasterClassName() {
        return this.broadcasterClassName;
    }

    void setBroadcasterClassName(String name) {
        this.broadcasterClassName = name;
    }

    boolean isBroadcasterSpecified() {
        return this.broadcasterSpecified;
    }

    void setBroadcasterSpecified(boolean specified) {
        this.broadcasterSpecified = specified;
    }

    BroadcasterFactory broadcasterFactory() {
        return this.broadcasterFactory;
    }

    void setBroadcasterFactory(BroadcasterFactory factory) {
        this.broadcasterFactory = factory;
    }

    String broadcasterCacheClassName() {
        return this.broadcasterCacheClassName;
    }

    void setBroadcasterCacheClassName(String name) {
        this.broadcasterCacheClassName = name;
    }

    String broadcasterLifeCyclePolicy() {
        return this.broadcasterLifeCyclePolicy;
    }

    void setBroadcasterLifeCyclePolicy(String policy) {
        this.broadcasterLifeCyclePolicy = policy;
    }

    void setBroadcasterFactoryClassName(String name) {
        this.broadcasterFactoryClassName = name;
    }

    void setDefaultSerializerClassName(String name) {
        this.defaultSerializerClassName = name;
    }

    String defaultSerializerClassName() {
        return this.defaultSerializerClassName;
    }

    Class<Serializer> defaultSerializerClass() {
        return this.defaultSerializerClass;
    }

    AtmosphereResourceFactory arFactory() {
        return this.arFactory;
    }

    void setArFactory(AtmosphereResourceFactory factory) {
        this.arFactory = factory;
    }

    MetaBroadcaster metaBroadcaster() {
        return this.metaBroadcaster;
    }

    void destroyFactories() {
        if (this.broadcasterFactory != null) {
            this.broadcasterFactory.destroy();
        }
        if (this.metaBroadcaster != null) {
            this.metaBroadcaster.destroy();
        }
        if (this.arFactory != null) {
            this.arFactory.destroy();
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.destroy();
        }
    }

    BroadcasterSetup(AtmosphereConfig config) {
        this.config = config;
    }

    void setHandlersSupplier(Supplier<Map<String, AtmosphereHandlerWrapper>> supplier) {
        this.handlersSupplier = supplier;
    }

    void parseInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.broadcasterClass");
        if (s != null) {
            this.broadcasterClassName = s;
            this.broadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterCacheClass")) != null) {
            this.broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcastFilterClasses")) != null) {
            this.broadcasterFilters.addAll(Arrays.asList(s.split(",")));
            logger.info("Installing BroadcastFilter class(es) {}", (Object)s);
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterLifeCyclePolicy")) != null) {
            this.broadcasterLifeCyclePolicy = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterFactory")) != null) {
            this.broadcasterFactoryClassName = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereResource.defaultSerializer")) != null) {
            this.defaultSerializerClassName = s;
        }
    }

    void populateBroadcasterType() {
        this.broadcasterTypes.add("org.atmosphere.kafka.KafkaBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.hazelcast.HazelcastBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.xmpp.XMPPBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.redis.RedisBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jgroups.JGroupsBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jms.JMSBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.rmi.RMIBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.rabbitmq.RabbitMQBroadcaster");
    }

    void configureBroadcasterFactory() {
        AtmosphereFramework fwk = this.config.framework();
        try {
            Class<?> bc;
            if (!this.broadcasterSpecified) {
                this.broadcasterClassName = this.lookupDefaultBroadcasterType(this.broadcasterClassName);
            }
            if (this.broadcasterFactoryClassName != null && this.broadcasterFactory == null) {
                this.broadcasterFactory = fwk.newClassInstance(BroadcasterFactory.class, IOUtils.loadClass(fwk.getClass(), this.broadcasterFactoryClassName));
                bc = IOUtils.loadClass(fwk.getClass(), this.broadcasterClassName);
                this.broadcasterFactory.configure(bc, this.broadcasterLifeCyclePolicy, this.config);
            }
            if (this.broadcasterFactory == null) {
                bc = IOUtils.loadClass(fwk.getClass(), this.broadcasterClassName);
                this.broadcasterFactory = fwk.newClassInstance(BroadcasterFactory.class, DefaultBroadcasterFactory.class);
                this.broadcasterFactory.configure(bc, this.broadcasterLifeCyclePolicy, this.config);
            }
            for (BroadcasterListener b : this.broadcasterListeners) {
                this.broadcasterFactory.addBroadcasterListener(b);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to configure Broadcaster/Factory/Cache", (Throwable)ex);
        }
    }

    void configureBroadcaster() {
        AtmosphereFramework fwk = this.config.framework();
        try {
            for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.handlersSupplier.get().entrySet()) {
                AtmosphereHandlerWrapper w = e.getValue();
                if (w.broadcaster() == null) {
                    w.setBroadcaster(this.broadcasterFactory.get(w.mapping()));
                    continue;
                }
                if (this.broadcasterCacheClassName == null || !w.broadcaster().getBroadcasterConfig().getBroadcasterCache().getClass().getName().equals(DefaultBroadcasterCache.class.getName())) continue;
                BroadcasterCache cache = fwk.newClassInstance(BroadcasterCache.class, IOUtils.loadClass(fwk.getClass(), this.broadcasterCacheClassName));
                cache.configure(this.config);
                w.broadcaster().getBroadcasterConfig().setBroadcasterCache(cache);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to configure Broadcaster/Factory/Cache", (Throwable)ex);
        }
    }

    String lookupDefaultBroadcasterType(String defaultB) {
        if (this.autodetectBroadcaster()) {
            for (String b : this.broadcasterTypes) {
                try {
                    Class.forName(b);
                    logger.info("Detected a Broadcaster {} on the classpath. This broadcaster will be used by default and will override any annotated resources. Set {} to false to change the behavior", (Object)b, (Object)"org.atmosphere.cpr.Broadcaster.scanClassPath");
                    this.broadcasterSpecified = true;
                    return b;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return defaultB;
    }

    boolean autodetectBroadcaster() {
        ServletConfig servletConfig = this.config.getServletConfig();
        if (servletConfig == null) {
            return true;
        }
        String autodetect = servletConfig.getInitParameter("org.atmosphere.cpr.Broadcaster.scanClassPath");
        return autodetect == null || Boolean.parseBoolean(autodetect);
    }

    void configureMetaBroadcaster() {
        AtmosphereFramework fwk = this.config.framework();
        try {
            this.metaBroadcaster = fwk.newClassInstance(MetaBroadcaster.class, DefaultMetaBroadcaster.class);
            this.metaBroadcaster.configure(this.config);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("", (Throwable)e);
        }
    }

    void configureAtmosphereResourceFactory() {
        if (this.arFactory != null) {
            return;
        }
        this.resourceFactoryLock.lock();
        try {
            if (this.arFactory != null) {
                return;
            }
            try {
                this.arFactory = this.config.framework().newClassInstance(AtmosphereResourceFactory.class, DefaultAtmosphereResourceFactory.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("", (Throwable)e);
            }
            this.arFactory.configure(this.config);
        }
        finally {
            this.resourceFactoryLock.unlock();
        }
    }

    void initDefaultSerializer() {
        block5: {
            if (this.defaultSerializerClassName != null && !this.defaultSerializerClassName.isEmpty()) {
                try {
                    Class<?> clazz = IOUtils.loadClass(Serializer.class, this.defaultSerializerClassName);
                    if (Serializer.class.isAssignableFrom(clazz)) {
                        this.defaultSerializerClass = clazz;
                        break block5;
                    }
                    logger.error("Default Serializer class name does not implement Serializer interface");
                    this.defaultSerializerClassName = null;
                    this.defaultSerializerClass = null;
                }
                catch (Exception e) {
                    logger.error("Unable to set default Serializer", (Throwable)e);
                    this.defaultSerializerClassName = null;
                    this.defaultSerializerClass = null;
                }
            } else {
                this.defaultSerializerClassName = null;
                this.defaultSerializerClass = null;
            }
        }
    }

    AtmosphereResourceSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    AtmosphereResourceSessionFactory getOrCreateSessionFactory() {
        if (this.sessionFactory != null) {
            return this.sessionFactory;
        }
        this.sessionFactoryLock.lock();
        try {
            if (this.sessionFactory == null) {
                try {
                    this.sessionFactory = this.config.framework().newClassInstance(AtmosphereResourceSessionFactory.class, DefaultAtmosphereResourceSessionFactory.class);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        finally {
            this.sessionFactoryLock.unlock();
        }
        return this.sessionFactory;
    }

    AtmosphereResourceFactory getOrCreateAtmosphereFactory() {
        if (this.arFactory == null) {
            this.configureAtmosphereResourceFactory();
        }
        return this.arFactory;
    }

    void clear() {
        this.broadcasterFilters.clear();
        this.broadcasterTypes.clear();
        this.inspectors.clear();
        this.broadcasterListeners.clear();
        this.broadcasterCacheListeners.clear();
        this.filterManipulators.clear();
        this.broadcasterFactory = null;
        this.arFactory = null;
        this.metaBroadcaster = null;
        this.sessionFactory = null;
    }
}

