/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.annotation;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.atmosphere.util.annotation.ClassFileBuffer;
import org.atmosphere.util.annotation.ClassFileIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationDetector {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationDetector.class);
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int CP_METHOD_HANDLE = 15;
    private static final int CP_METHOD_TYPE = 16;
    private static final int CP_INVOKE_DYNAMIC = 18;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private static final int ARRAY = 91;
    private final ClassFileBuffer cpBuffer = new ClassFileBuffer();
    private final Map<String, Class<? extends Annotation>> annotations;
    private TypeReporter typeReporter;
    private FieldReporter fieldReporter;
    private MethodReporter methodReporter;
    private String typeName;
    private Object[] constantPool;
    private String memberName;

    public AnnotationDetector(Reporter reporter) {
        Class<? extends Annotation>[] a = reporter.annotations();
        this.annotations = new HashMap<String, Class<? extends Annotation>>(a.length);
        for (Class<? extends Annotation> aClass : a) {
            this.annotations.put("L" + aClass.getName().replace('.', '/') + ";", aClass);
        }
        if (reporter instanceof TypeReporter) {
            TypeReporter tr;
            this.typeReporter = tr = (TypeReporter)reporter;
        }
        if (reporter instanceof FieldReporter) {
            FieldReporter fr;
            this.fieldReporter = fr = (FieldReporter)reporter;
        }
        if (reporter instanceof MethodReporter) {
            MethodReporter mr;
            this.methodReporter = mr = (MethodReporter)reporter;
        }
        if (this.typeReporter == null && this.fieldReporter == null && this.methodReporter == null) {
            throw new AssertionError((Object)"No reporter defined");
        }
    }

    public void detect() throws IOException {
        this.detect(new ClassFileIterator());
    }

    public void detect(String ... packageNames) throws IOException {
        String[] pkgNameFilter = new String[packageNames.length];
        for (int i = 0; i < pkgNameFilter.length; ++i) {
            pkgNameFilter[i] = packageNames[i].replace('.', '/');
            if (pkgNameFilter[i].endsWith("/")) continue;
            pkgNameFilter[i] = pkgNameFilter[i].concat("/");
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<InputStream> streams = new HashSet<InputStream>();
        for (String packageName : pkgNameFilter) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resourceEnum = loader.getResources(packageName);
            while (resourceEnum.hasMoreElements()) {
                File jarFile;
                URL url = resourceEnum.nextElement();
                if ("file".equals(url.getProtocol())) {
                    File dir = this.toFile(url);
                    if (!dir.isDirectory()) continue;
                    files.add(dir);
                    AnnotationDetector.print("Add directory: '%s'", dir);
                    continue;
                }
                try {
                    jarFile = this.toFile(((JarURLConnection)url.openConnection()).getJarFileURL());
                }
                catch (ClassCastException cce) {
                    try {
                        Object u = url.toExternalForm();
                        if (((String)u).startsWith("zip:")) {
                            if (!((String)(u = ((String)u).substring(4))).startsWith("file:")) {
                                u = "file:" + (String)u;
                            }
                            u = ((String)u).substring(0, ((String)u).indexOf("!"));
                        }
                        jarFile = this.toFile(URI.create((String)u).toURL());
                    }
                    catch (Exception ex) {
                        throw new AssertionError((Object)("Not a File: " + url.toExternalForm()));
                    }
                }
                try {
                    if (jarFile.isFile()) {
                        files.add(jarFile);
                        AnnotationDetector.print("Add jar file: '%s'", jarFile);
                        continue;
                    }
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        JarURLConnection juc = (JarURLConnection)urlConnection;
                        this.loadJarContent(juc, packageName, streams);
                        continue;
                    }
                    streams.add(url.openConnection().getInputStream());
                }
                catch (Exception ex) {
                    AnnotationDetector.print("Cannot load from jar file", ex);
                }
            }
        }
        if (!files.isEmpty()) {
            this.detect(new ClassFileIterator(files.toArray(new File[0]), pkgNameFilter));
        } else if (!streams.isEmpty()) {
            this.detect(new ClassFileIterator(streams.toArray(new InputStream[0]), pkgNameFilter));
        }
    }

    private void loadJarContent(JarURLConnection url, String packageName, Set<InputStream> streams) throws IOException {
        JarFile jarFile = url.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(packageName)) continue;
            streams.add(jarFile.getInputStream(entry));
        }
    }

    public void detect(File ... filesOrDirectories) throws IOException {
        AnnotationDetector.print("detectFilesOrDirectories: %s", new Object[]{filesOrDirectories});
        this.detect(new ClassFileIterator(filesOrDirectories, null));
    }

    private File toFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            try {
                return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (Exception ex2) {
                throw new MalformedURLException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detect(ClassFileIterator iterator) throws IOException {
        InputStream stream;
        while ((stream = iterator.next()) != null) {
            try {
                this.cpBuffer.readFrom(stream);
                if (!this.hasCafebabe(this.cpBuffer)) continue;
                this.detect(this.cpBuffer);
            }
            catch (Throwable t) {
                if (iterator.isFile()) continue;
                stream.close();
            }
            finally {
                if (!iterator.isFile()) continue;
                stream.close();
            }
        }
    }

    private boolean hasCafebabe(ClassFileBuffer buffer) throws IOException {
        return buffer.size() > 4 && buffer.readInt() == -889275714;
    }

    private void detect(DataInput di) throws IOException {
        this.readVersion(di);
        this.readConstantPoolEntries(di);
        this.readAccessFlags(di);
        this.readThisClass(di);
        this.readSuperClass(di);
        this.readInterfaces(di);
        this.readFields(di);
        this.readMethods(di);
        this.readAttributes(di, 'T', this.typeReporter == null);
    }

    private void readVersion(DataInput di) throws IOException {
        if (logger.isDebugEnabled()) {
            AnnotationDetector.print("Java Class version %2$d.%1$d", di.readUnsignedShort(), di.readUnsignedShort());
        } else {
            di.skipBytes(4);
        }
    }

    private void readConstantPoolEntries(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        this.constantPool = new Object[count];
        for (int i = 1; i < count; ++i) {
            if (!this.readConstantPoolEntry(di, i)) continue;
            ++i;
        }
    }

    private boolean readConstantPoolEntry(DataInput di, int index) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 1: {
                this.constantPool[index] = di.readUTF();
                return false;
            }
            case 3: {
                di.skipBytes(4);
                return false;
            }
            case 4: {
                di.skipBytes(4);
                return false;
            }
            case 5: {
                di.skipBytes(8);
                return true;
            }
            case 6: {
                di.skipBytes(8);
                return true;
            }
            case 7: 
            case 8: {
                this.constantPool[index] = di.readUnsignedShort();
                return false;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                di.skipBytes(4);
                return false;
            }
            case 15: {
                di.skipBytes(3);
                return false;
            }
            case 16: {
                di.skipBytes(2);
                return false;
            }
            case 18: {
                di.skipBytes(4);
                return false;
            }
        }
        throw new ClassFormatError("Unkown tag value for constant pool entry: " + tag);
    }

    private void readAccessFlags(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readThisClass(DataInput di) throws IOException {
        this.typeName = this.resolveUtf8(di);
        AnnotationDetector.print("read type '%s'", this.typeName);
    }

    private void readSuperClass(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readInterfaces(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        di.skipBytes(count * 2);
    }

    private void readFields(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        AnnotationDetector.print("field count = %d", count);
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(di);
            this.memberName = this.resolveUtf8(di);
            String descriptor = this.resolveUtf8(di);
            this.readAttributes(di, 'F', this.fieldReporter == null);
            AnnotationDetector.print("Field: %s, descriptor: %s", this.memberName, descriptor);
        }
    }

    private void readMethods(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        AnnotationDetector.print("method count = %d", count);
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(di);
            this.memberName = this.resolveUtf8(di);
            String descriptor = this.resolveUtf8(di);
            this.readAttributes(di, 'M', this.methodReporter == null);
            AnnotationDetector.print("Method: %s, descriptor: %s", this.memberName, descriptor);
        }
    }

    private void readAttributes(DataInput di, char reporterType, boolean skipReporting) throws IOException {
        int count = di.readUnsignedShort();
        AnnotationDetector.print("attribute count (%s) = %d", Character.valueOf(reporterType), count);
        for (int i = 0; i < count; ++i) {
            String name = this.resolveUtf8(di);
            int length = di.readInt();
            if (!skipReporting && ("RuntimeVisibleAnnotations".equals(name) || "RuntimeInvisibleAnnotations".equals(name))) {
                this.readAnnotations(di, reporterType);
                continue;
            }
            AnnotationDetector.print("skip attribute %s", name);
            di.skipBytes(length);
        }
    }

    private void readAnnotations(DataInput di, char reporterType) throws IOException {
        int count = di.readUnsignedShort();
        AnnotationDetector.print("annotation count (%s) = %d", Character.valueOf(reporterType), count);
        block5: for (int i = 0; i < count; ++i) {
            String rawTypeName = this.readAnnotation(di);
            Class<? extends Annotation> type = this.annotations.get(rawTypeName);
            if (type == null) continue;
            String externalTypeName = this.typeName.replace('/', '.');
            switch (reporterType) {
                case 'T': {
                    this.typeReporter.reportTypeAnnotation(type, externalTypeName);
                    continue block5;
                }
                case 'F': {
                    this.fieldReporter.reportFieldAnnotation(type, externalTypeName, this.memberName);
                    continue block5;
                }
                case 'M': {
                    this.methodReporter.reportMethodAnnotation(type, externalTypeName, this.memberName);
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("reporterType=" + reporterType));
                }
            }
        }
    }

    private String readAnnotation(DataInput di) throws IOException {
        String rawTypeName = this.resolveUtf8(di);
        int count = di.readUnsignedShort();
        AnnotationDetector.print("annotation elements count: %d", count);
        for (int i = 0; i < count; ++i) {
            if (logger.isDebugEnabled()) {
                AnnotationDetector.print("element '%s'", this.resolveUtf8(di));
            } else {
                di.skipBytes(2);
            }
            this.readAnnotationElementValue(di);
        }
        return rawTypeName;
    }

    private void readAnnotationElementValue(DataInput di) throws IOException {
        int tag = di.readUnsignedByte();
        AnnotationDetector.print("tag='%c'", Character.valueOf((char)tag));
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                di.skipBytes(2);
                break;
            }
            case 101: {
                di.skipBytes(4);
                break;
            }
            case 99: {
                di.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(di);
                break;
            }
            case 91: {
                int count = di.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    this.readAnnotationElementValue(di);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private String resolveUtf8(DataInput di) throws IOException {
        String s;
        int index = di.readUnsignedShort();
        Object value = this.constantPool[index];
        if (value instanceof Integer) {
            Integer intVal = (Integer)value;
            s = (String)this.constantPool[intVal];
            AnnotationDetector.print("resolveUtf8(%d): %d --> %s", index, value, s);
        } else {
            s = (String)value;
            AnnotationDetector.print("resolveUtf8(%d): %s", index, s);
        }
        return s;
    }

    private static void print(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            String logMessage;
            if (args.length == 0) {
                logMessage = message;
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    if (args[i].getClass().isArray()) {
                        args[i] = Arrays.toString((Object[])args[i]);
                        continue;
                    }
                    if (args[i] != Class.class) continue;
                    args[i] = ((Class)args[i]).getName();
                }
                logMessage = String.format(message, args);
            }
            logger.trace(logMessage);
        }
    }

    public void destroy() {
        this.annotations.clear();
        this.constantPool = null;
        this.cpBuffer.destroy();
    }

    public static interface Reporter {
        public Class<? extends Annotation>[] annotations();
    }

    public static interface TypeReporter
    extends Reporter {
        public void reportTypeAnnotation(Class<? extends Annotation> var1, String var2);
    }

    public static interface FieldReporter
    extends Reporter {
        public void reportFieldAnnotation(Class<? extends Annotation> var1, String var2, String var3);
    }

    public static interface MethodReporter
    extends Reporter {
        public void reportMethodAnnotation(Class<? extends Annotation> var1, String var2, String var3);
    }
}

