/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.inject.InjectableObjectFactory;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static boolean RUNNING_TEST = false;
    private static final Logger LOGGER;

    public static boolean webSocketEnabled(HttpServletRequest request) {
        boolean allowWebSocketWithoutHeaders;
        if (Utils.closeMessage(request) || !Utils.webSocketQueryStringPresentOrNull(request)) {
            return false;
        }
        boolean bl = allowWebSocketWithoutHeaders = request.getHeader("X-Atmosphere-WebSocket-Proxy") != null;
        if (allowWebSocketWithoutHeaders) {
            return true;
        }
        return Utils.rawWebSocket(request);
    }

    public static boolean rawWebSocket(HttpServletRequest request) {
        Enumeration connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)connection.nextElement()).split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean firefoxWebSocketEnabled(HttpServletRequest request) {
        return Utils.webSocketEnabled(request) && request.getHeader("X-atmo-protocol") != null && request.getHeader("X-atmo-protocol").equals("true") && request.getHeader("User-Agent") != null && request.getHeader("User-Agent").toLowerCase().contains("firefox");
    }

    public static boolean twoConnectionsTransport(AtmosphereResource.TRANSPORT t) {
        return switch (t) {
            case AtmosphereResource.TRANSPORT.JSONP, AtmosphereResource.TRANSPORT.LONG_POLLING, AtmosphereResource.TRANSPORT.STREAMING, AtmosphereResource.TRANSPORT.SSE, AtmosphereResource.TRANSPORT.POLLING, AtmosphereResource.TRANSPORT.HTMLFILE -> true;
            default -> false;
        };
    }

    public static boolean webSocketQueryStringPresentOrNull(HttpServletRequest request) {
        String transport = request.getHeader("X-Atmosphere-Transport");
        if (transport == null) {
            return true;
        }
        return transport.equalsIgnoreCase("websocket");
    }

    public static boolean resumableTransport(AtmosphereResource.TRANSPORT t) {
        return switch (t) {
            case AtmosphereResource.TRANSPORT.JSONP, AtmosphereResource.TRANSPORT.LONG_POLLING -> true;
            default -> false;
        };
    }

    public static boolean pollableTransport(AtmosphereResource.TRANSPORT t) {
        return switch (t) {
            case AtmosphereResource.TRANSPORT.POLLING, AtmosphereResource.TRANSPORT.CLOSE, AtmosphereResource.TRANSPORT.AJAX -> true;
            default -> false;
        };
    }

    public static boolean pushMessage(AtmosphereResource.TRANSPORT t) {
        return switch (t) {
            case AtmosphereResource.TRANSPORT.POLLING, AtmosphereResource.TRANSPORT.AJAX, AtmosphereResource.TRANSPORT.UNDEFINED -> true;
            default -> false;
        };
    }

    public static boolean atmosphereProtocol(AtmosphereRequest r) {
        String p = r.getHeader("X-atmo-protocol");
        return Boolean.parseBoolean(p);
    }

    public static boolean webSocketMessage(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)r).getRequest(false);
        return request.getAttribute(FrameworkConfig.WEBSOCKET_MESSAGE) != null;
    }

    public static boolean properProtocol(HttpServletRequest request) {
        boolean isWebSocket;
        Enumeration connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        boolean isOK = false;
        boolean bl = isWebSocket = request.getHeader("sec-websocket-version") != null || request.getHeader("Sec-WebSocket-Draft") != null;
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)connection.nextElement()).split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("upgrade")) continue;
                isOK = true;
                break;
            }
        }
        return !isWebSocket || isOK;
    }

    public static AtmosphereResource websocketResource(AtmosphereResource r) {
        String parentUUID = (String)((AtmosphereResourceImpl)r).getRequest(false).getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
        if (parentUUID != null) {
            return r.getAtmosphereConfig().resourcesFactory().findResource(parentUUID).orElse(r);
        }
        return r;
    }

    public static boolean closeMessage(HttpServletRequest request) {
        String s = request.getHeader("X-Atmosphere-Transport");
        return s != null && s.equalsIgnoreCase("close");
    }

    public static Object invoke(Object proxiedInstance, Method m, Object o) {
        if (m != null) {
            try {
                Object[] objectArray;
                if (o == null || m.getParameterTypes().length == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = o;
                }
                return m.invoke(proxiedInstance, objectArray);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        LOGGER.trace("No Method Mapped for {}", o);
        return null;
    }

    public static void inject(AtmosphereResource r) throws IllegalAccessException {
        AtmosphereConfig config = r.getAtmosphereConfig();
        if (config.properties().get(FrameworkConfig.NEED_RUNTIME_INJECTION) == null) {
            return;
        }
        AtmosphereObjectFactory<?> injectableFactory = config.framework().objectFactory();
        if (!(injectableFactory instanceof InjectableObjectFactory)) {
            return;
        }
        Object injectIn = Utils.injectWith(r);
        if (injectIn != null) {
            Utils.inject(injectIn, injectIn.getClass(), r);
        }
    }

    public static void inject(Object object, Class<?> clazz, AtmosphereResource r) throws IllegalAccessException {
        ((InjectableObjectFactory)r.getAtmosphereConfig().framework().objectFactory()).requestScoped(object, clazz, r);
    }

    public static void inject(Object object, Class<?> clazz, AtmosphereConfig config) throws IllegalAccessException {
        ((InjectableObjectFactory)config.framework().objectFactory()).requestScoped(object, clazz);
    }

    private static Object injectWith(AtmosphereResource r) {
        AtmosphereHandler h = r.getAtmosphereHandler();
        if (AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER.getClass().isInstance(h)) {
            WebSocketHandler webSocketHandler;
            WebSocket w = ((AtmosphereResourceImpl)r).webSocket();
            if (w != null && (webSocketHandler = w.webSocketHandler()) instanceof WebSocketProcessor.WebSocketHandlerProxy) {
                WebSocketProcessor.WebSocketHandlerProxy proxy = (WebSocketProcessor.WebSocketHandlerProxy)webSocketHandler;
                return proxy.proxied();
            }
            return null;
        }
        return Utils.injectWith(h);
    }

    private static Object injectWith(AtmosphereHandler h) {
        if (h instanceof AnnotatedProxy) {
            AnnotatedProxy annotatedProxy = (AnnotatedProxy)h;
            return annotatedProxy.target();
        }
        if (h instanceof ReflectorServletProcessor) {
            ReflectorServletProcessor reflectorServletProcessor = (ReflectorServletProcessor)h;
            return reflectorServletProcessor.getServlet();
        }
        return h;
    }

    public static Set<Field> getInheritedPrivateFields(Class<?> type) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static Set<Method> getInheritedPrivateMethod(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Method m : i.getDeclaredMethods()) {
                if (m.isSynthetic()) continue;
                result.add(m);
            }
        }
        return result;
    }

    public static boolean requestScopedInjection(AtmosphereConfig config, AtmosphereHandler h) {
        AtmosphereObjectFactory<?> injectableFactory = config.framework().objectFactory();
        if (!(injectableFactory instanceof InjectableObjectFactory)) {
            return false;
        }
        InjectableObjectFactory iof = (InjectableObjectFactory)injectableFactory;
        try {
            Object obj = Utils.injectWith(h);
            return obj != null && iof.needRequestScoped(obj.getClass());
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
    }

    public static boolean requestScopedInjection(AtmosphereConfig config, Object o) {
        AtmosphereObjectFactory<?> injectableFactory = config.framework().objectFactory();
        if (!(injectableFactory instanceof InjectableObjectFactory)) {
            return false;
        }
        InjectableObjectFactory iof = (InjectableObjectFactory)injectableFactory;
        try {
            return iof.needRequestScoped(o.getClass());
        }
        catch (Exception var4) {
            LOGGER.error("", (Throwable)var4);
            return false;
        }
    }

    public static String pathInfo(AtmosphereRequest request) {
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Object path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || ((String)path).isEmpty()) {
            path = "/";
        }
        return path;
    }

    public static boolean isRunningTest() {
        return RUNNING_TEST;
    }

    static {
        try {
            Class.forName("org.testng.TestNG");
            RUNNING_TEST = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOGGER = LoggerFactory.getLogger(Utils.class);
    }
}

