/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ThreadLocalProxy<T>
implements InvocationHandler {
    private final ThreadLocal<T> threadLocalInstance = new ThreadLocal();

    public void set(T instance) {
        this.threadLocalInstance.set(instance);
    }

    public T get() {
        return this.threadLocalInstance.get();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        T instance = this.threadLocalInstance.get();
        if (instance == null) {
            throw new IllegalStateException("No thread-local instance for " + String.valueOf(proxy.getClass()));
        }
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

