/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathTemplate {
    private static final Set<Character> RESERVED = Set.of(Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('('), Character.valueOf(')'));
    private static final String DEFAULT_VAR_REGEX = "[^/]+?";
    private final String template;
    private final Pattern pattern;
    private final List<String> variableNames;
    private final int[] groupIndexes;

    public PathTemplate(String template) {
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("Template must not be null or empty");
        }
        this.template = template;
        this.variableNames = new ArrayList<String>();
        StringBuilder regex = new StringBuilder();
        ArrayList<Integer> groupCounts = new ArrayList<Integer>();
        int i = 0;
        while (i < template.length()) {
            char c = template.charAt(i);
            if (c == '{') {
                String varRegex;
                String name;
                int close = PathTemplate.findClosingBrace(template, i);
                String expr = template.substring(i + 1, close).strip();
                int colon = expr.indexOf(58);
                if (colon >= 0) {
                    name = expr.substring(0, colon).strip();
                    varRegex = expr.substring(colon + 1).strip();
                } else {
                    name = expr;
                    varRegex = DEFAULT_VAR_REGEX;
                }
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Empty variable name at position " + i);
                }
                this.variableNames.add(name);
                regex.append('(').append(varRegex).append(')');
                int gc = PathTemplate.countGroups(varRegex) + 1;
                groupCounts.add(gc);
                i = close + 1;
                continue;
            }
            if (RESERVED.contains(Character.valueOf(c))) {
                regex.append('\\');
            }
            regex.append(c);
            ++i;
        }
        this.pattern = Pattern.compile(regex.toString());
        this.groupIndexes = PathTemplate.buildGroupIndexes(groupCounts);
    }

    public boolean match(CharSequence uri, Map<String, String> vars) {
        if (uri == null || vars == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        vars.clear();
        for (int i = 0; i < this.variableNames.size(); ++i) {
            String name = this.variableNames.get(i);
            int groupIdx = this.groupIndexes[i];
            String value = m.group(groupIdx);
            String prev = vars.get(name);
            if (prev != null && !prev.equals(value)) {
                return false;
            }
            vars.put(name, value);
        }
        return true;
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return this.template;
    }

    private static int findClosingBrace(String s, int openPos) {
        int depth = 1;
        for (int i = openPos + 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            return i;
        }
        throw new IllegalArgumentException("Unclosed '{' at position " + openPos + " in template: " + s);
    }

    private static int countGroups(String regex) {
        int count = 0;
        for (int i = 0; i < regex.length(); ++i) {
            char c = regex.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '(' || i + 1 < regex.length() && regex.charAt(i + 1) == '?') continue;
            ++count;
        }
        return count;
    }

    private static int[] buildGroupIndexes(List<Integer> groupCounts) {
        int[] indexes = new int[groupCounts.size()];
        int current = 1;
        for (int i = 0; i < groupCounts.size(); ++i) {
            indexes[i] = current;
            current += groupCounts.get(i).intValue();
        }
        return indexes;
    }
}

