/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.HashMap;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.PathTemplate;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointMapper<U>
implements EndpointMapper<U> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointMapper.class);

    protected U match(String path, Map<String, U> handlers) {
        U handler = handlers.get(path);
        if (handler == null) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Map.Entry<String, U> e : handlers.entrySet()) {
                try {
                    PathTemplate t = new PathTemplate(e.getKey());
                    logger.trace("Trying to map {} to {}", (Object)t, (Object)path);
                    if (!t.match(path, m)) continue;
                    handler = e.getValue();
                    logger.trace("Mapped {} to {}", (Object)t, e.getValue());
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return handler;
    }

    public String computePath(AtmosphereRequest req) {
        return Utils.pathInfo(req);
    }

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public U map(AtmosphereRequest req, Map<String, U> handlers) {
        String path = this.computePath(req);
        U handler = this.map(path, handlers);
        if (handler == null && (handler = this.map(path + (path.endsWith("/") ? "all" : "/all"), handlers)) == null) {
            handler = this.map(path + "*", handlers);
            if (handler == null) {
                String p;
                String string = p = path.lastIndexOf("/") <= 0 ? "/" : path.substring(0, path.lastIndexOf("/"));
                while (p.length() > 0 && (handler = this.map(p, handlers)) == null) {
                    p = p.substring(0, p.lastIndexOf("/"));
                }
            }
            if (handler == null && req.getContextPath().length() < path.length()) {
                path = path.substring(req.getContextPath().length());
                handler = this.map(path, handlers);
            }
        }
        req.setAttribute(FrameworkConfig.MAPPED_PATH, path);
        return handler;
    }

    @Override
    public U map(String path, Map<String, U> handlers) {
        U handler;
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if ((handler = this.match(path, handlers)) == null) {
            handler = this.match(path + (path.endsWith("/") ? "all" : "/all"), handlers);
            if (handler == null && (handler = this.match(path + "*", handlers)) == null) {
                String p;
                String string = p = path.lastIndexOf("/") <= 0 ? "/" : path.substring(0, path.lastIndexOf("/"));
                while (p.contains("/") && (handler = this.match(p, handlers)) == null) {
                    p = p.substring(0, p.lastIndexOf("/"));
                }
            }
        }
        return handler;
    }
}

